<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeDetails Structs
 * Meta informations extracted from the WSDL
 * - documentation: Car segment Approximate price fields – ‘/AP-¤USD281.27 UNL 3DY 0HR 41.97SSQ 123.11MC/RC-¤STDR/CF-G31214927E8-‘
 * @subpackage Structs
 */
class ChargeDetails extends AbstractStructBase
{
    /**
     * The ChargeBreakdown
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ChargeBreakdown
     */
    public $ChargeBreakdown;
    /**
     * The DiscontinueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DiscontinueDate;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $EffectiveDate;
    /**
     * The PurchaseBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $PurchaseBy;
    /**
     * The ReasonForIssuance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ReasonForIssuance
     */
    public $ReasonForIssuance;
    /**
     * The SSIM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SSIM
     */
    public $SSIM;
    /**
     * The SSR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SSR
     */
    public $SSR;
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Ticket
     */
    public $Ticket;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\TourCode
     */
    public $TourCode;
    /**
     * The VendorPrefs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\VendorPrefs
     */
    public $VendorPrefs;
    /**
     * The CommericalName
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CommericalName;
    /**
     * The DisplayOnly
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DisplayOnly;
    /**
     * The EMD_Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $EMD_Type;
    /**
     * The FeeApplication
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FeeApplication;
    /**
     * The FQTV_Tier
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FQTV_Tier;
    /**
     * The GuaranteeInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $GuaranteeInd;
    /**
     * The IATA_Application
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IATA_Application;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Owner;
    /**
     * The RefundForm
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RefundForm;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The SegmentJourneyCouponInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SegmentJourneyCouponInd;
    /**
     * The ApproximateTotalCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge[]
     */
    public $ApproximateTotalCharge;
    /**
     * Constructor method for ChargeDetails
     * @uses ChargeDetails::setChargeBreakdown()
     * @uses ChargeDetails::setDiscontinueDate()
     * @uses ChargeDetails::setEffectiveDate()
     * @uses ChargeDetails::setPurchaseBy()
     * @uses ChargeDetails::setReasonForIssuance()
     * @uses ChargeDetails::setSSIM()
     * @uses ChargeDetails::setSSR()
     * @uses ChargeDetails::setTicket()
     * @uses ChargeDetails::setTourCode()
     * @uses ChargeDetails::setVendorPrefs()
     * @uses ChargeDetails::setCommericalName()
     * @uses ChargeDetails::setDisplayOnly()
     * @uses ChargeDetails::setEMD_Type()
     * @uses ChargeDetails::setFeeApplication()
     * @uses ChargeDetails::setFQTV_Tier()
     * @uses ChargeDetails::setGuaranteeInd()
     * @uses ChargeDetails::setIATA_Application()
     * @uses ChargeDetails::setNameNumber()
     * @uses ChargeDetails::setOwner()
     * @uses ChargeDetails::setRefundForm()
     * @uses ChargeDetails::setRPH()
     * @uses ChargeDetails::setSegmentJourneyCouponInd()
     * @uses ChargeDetails::setApproximateTotalCharge()
     * @param \Sabre\EnhancedAirBook\Structs\ChargeBreakdown $chargeBreakdown
     * @param string $discontinueDate
     * @param string $effectiveDate
     * @param string $purchaseBy
     * @param \Sabre\EnhancedAirBook\Structs\ReasonForIssuance $reasonForIssuance
     * @param \Sabre\EnhancedAirBook\Structs\SSIM $sSIM
     * @param \Sabre\EnhancedAirBook\Structs\SSR $sSR
     * @param \Sabre\EnhancedAirBook\Structs\Ticket $ticket
     * @param \Sabre\EnhancedAirBook\Structs\TourCode $tourCode
     * @param \Sabre\EnhancedAirBook\Structs\VendorPrefs $vendorPrefs
     * @param string $commericalName
     * @param string $displayOnly
     * @param string $eMD_Type
     * @param string $feeApplication
     * @param string $fQTV_Tier
     * @param string $guaranteeInd
     * @param string $iATA_Application
     * @param string $nameNumber
     * @param string $owner
     * @param string $refundForm
     * @param string $rPH
     * @param string $segmentJourneyCouponInd
     * @param \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge[] $approximateTotalCharge
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\ChargeBreakdown $chargeBreakdown = null, $discontinueDate = null, $effectiveDate = null, $purchaseBy = null, \Sabre\EnhancedAirBook\Structs\ReasonForIssuance $reasonForIssuance = null, \Sabre\EnhancedAirBook\Structs\SSIM $sSIM = null, \Sabre\EnhancedAirBook\Structs\SSR $sSR = null, \Sabre\EnhancedAirBook\Structs\Ticket $ticket = null, \Sabre\EnhancedAirBook\Structs\TourCode $tourCode = null, \Sabre\EnhancedAirBook\Structs\VendorPrefs $vendorPrefs = null, $commericalName = null, $displayOnly = null, $eMD_Type = null, $feeApplication = null, $fQTV_Tier = null, $guaranteeInd = null, $iATA_Application = null, $nameNumber = null, $owner = null, $refundForm = null, $rPH = null, $segmentJourneyCouponInd = null, array $approximateTotalCharge = array())
    {
        $this
            ->setChargeBreakdown($chargeBreakdown)
            ->setDiscontinueDate($discontinueDate)
            ->setEffectiveDate($effectiveDate)
            ->setPurchaseBy($purchaseBy)
            ->setReasonForIssuance($reasonForIssuance)
            ->setSSIM($sSIM)
            ->setSSR($sSR)
            ->setTicket($ticket)
            ->setTourCode($tourCode)
            ->setVendorPrefs($vendorPrefs)
            ->setCommericalName($commericalName)
            ->setDisplayOnly($displayOnly)
            ->setEMD_Type($eMD_Type)
            ->setFeeApplication($feeApplication)
            ->setFQTV_Tier($fQTV_Tier)
            ->setGuaranteeInd($guaranteeInd)
            ->setIATA_Application($iATA_Application)
            ->setNameNumber($nameNumber)
            ->setOwner($owner)
            ->setRefundForm($refundForm)
            ->setRPH($rPH)
            ->setSegmentJourneyCouponInd($segmentJourneyCouponInd)
            ->setApproximateTotalCharge($approximateTotalCharge);
    }
    /**
     * Get ChargeBreakdown value
     * @return \Sabre\EnhancedAirBook\Structs\ChargeBreakdown|null
     */
    public function getChargeBreakdown()
    {
        return $this->ChargeBreakdown;
    }
    /**
     * Set ChargeBreakdown value
     * @param \Sabre\EnhancedAirBook\Structs\ChargeBreakdown $chargeBreakdown
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setChargeBreakdown(\Sabre\EnhancedAirBook\Structs\ChargeBreakdown $chargeBreakdown = null)
    {
        $this->ChargeBreakdown = $chargeBreakdown;
        return $this;
    }
    /**
     * Get DiscontinueDate value
     * @return string|null
     */
    public function getDiscontinueDate()
    {
        return $this->DiscontinueDate;
    }
    /**
     * Set DiscontinueDate value
     * @param string $discontinueDate
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setDiscontinueDate($discontinueDate = null)
    {
        $this->DiscontinueDate = $discontinueDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get PurchaseBy value
     * @return string|null
     */
    public function getPurchaseBy()
    {
        return $this->PurchaseBy;
    }
    /**
     * Set PurchaseBy value
     * @param string $purchaseBy
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setPurchaseBy($purchaseBy = null)
    {
        $this->PurchaseBy = $purchaseBy;
        return $this;
    }
    /**
     * Get ReasonForIssuance value
     * @return \Sabre\EnhancedAirBook\Structs\ReasonForIssuance|null
     */
    public function getReasonForIssuance()
    {
        return $this->ReasonForIssuance;
    }
    /**
     * Set ReasonForIssuance value
     * @param \Sabre\EnhancedAirBook\Structs\ReasonForIssuance $reasonForIssuance
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setReasonForIssuance(\Sabre\EnhancedAirBook\Structs\ReasonForIssuance $reasonForIssuance = null)
    {
        $this->ReasonForIssuance = $reasonForIssuance;
        return $this;
    }
    /**
     * Get SSIM value
     * @return \Sabre\EnhancedAirBook\Structs\SSIM|null
     */
    public function getSSIM()
    {
        return $this->SSIM;
    }
    /**
     * Set SSIM value
     * @param \Sabre\EnhancedAirBook\Structs\SSIM $sSIM
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setSSIM(\Sabre\EnhancedAirBook\Structs\SSIM $sSIM = null)
    {
        $this->SSIM = $sSIM;
        return $this;
    }
    /**
     * Get SSR value
     * @return \Sabre\EnhancedAirBook\Structs\SSR|null
     */
    public function getSSR()
    {
        return $this->SSR;
    }
    /**
     * Set SSR value
     * @param \Sabre\EnhancedAirBook\Structs\SSR $sSR
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setSSR(\Sabre\EnhancedAirBook\Structs\SSR $sSR = null)
    {
        $this->SSR = $sSR;
        return $this;
    }
    /**
     * Get Ticket value
     * @return \Sabre\EnhancedAirBook\Structs\Ticket|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param \Sabre\EnhancedAirBook\Structs\Ticket $ticket
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setTicket(\Sabre\EnhancedAirBook\Structs\Ticket $ticket = null)
    {
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get TourCode value
     * @return \Sabre\EnhancedAirBook\Structs\TourCode|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param \Sabre\EnhancedAirBook\Structs\TourCode $tourCode
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setTourCode(\Sabre\EnhancedAirBook\Structs\TourCode $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get VendorPrefs value
     * @return \Sabre\EnhancedAirBook\Structs\VendorPrefs|null
     */
    public function getVendorPrefs()
    {
        return $this->VendorPrefs;
    }
    /**
     * Set VendorPrefs value
     * @param \Sabre\EnhancedAirBook\Structs\VendorPrefs $vendorPrefs
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setVendorPrefs(\Sabre\EnhancedAirBook\Structs\VendorPrefs $vendorPrefs = null)
    {
        $this->VendorPrefs = $vendorPrefs;
        return $this;
    }
    /**
     * Get CommericalName value
     * @return string|null
     */
    public function getCommericalName()
    {
        return $this->CommericalName;
    }
    /**
     * Set CommericalName value
     * @param string $commericalName
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setCommericalName($commericalName = null)
    {
        $this->CommericalName = $commericalName;
        return $this;
    }
    /**
     * Get DisplayOnly value
     * @return string|null
     */
    public function getDisplayOnly()
    {
        return $this->DisplayOnly;
    }
    /**
     * Set DisplayOnly value
     * @param string $displayOnly
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setDisplayOnly($displayOnly = null)
    {
        $this->DisplayOnly = $displayOnly;
        return $this;
    }
    /**
     * Get EMD_Type value
     * @return string|null
     */
    public function getEMD_Type()
    {
        return $this->EMD_Type;
    }
    /**
     * Set EMD_Type value
     * @param string $eMD_Type
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setEMD_Type($eMD_Type = null)
    {
        $this->EMD_Type = $eMD_Type;
        return $this;
    }
    /**
     * Get FeeApplication value
     * @return string|null
     */
    public function getFeeApplication()
    {
        return $this->FeeApplication;
    }
    /**
     * Set FeeApplication value
     * @param string $feeApplication
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setFeeApplication($feeApplication = null)
    {
        $this->FeeApplication = $feeApplication;
        return $this;
    }
    /**
     * Get FQTV_Tier value
     * @return string|null
     */
    public function getFQTV_Tier()
    {
        return $this->FQTV_Tier;
    }
    /**
     * Set FQTV_Tier value
     * @param string $fQTV_Tier
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setFQTV_Tier($fQTV_Tier = null)
    {
        $this->FQTV_Tier = $fQTV_Tier;
        return $this;
    }
    /**
     * Get GuaranteeInd value
     * @return string|null
     */
    public function getGuaranteeInd()
    {
        return $this->GuaranteeInd;
    }
    /**
     * Set GuaranteeInd value
     * @param string $guaranteeInd
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setGuaranteeInd($guaranteeInd = null)
    {
        $this->GuaranteeInd = $guaranteeInd;
        return $this;
    }
    /**
     * Get IATA_Application value
     * @return string|null
     */
    public function getIATA_Application()
    {
        return $this->IATA_Application;
    }
    /**
     * Set IATA_Application value
     * @param string $iATA_Application
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setIATA_Application($iATA_Application = null)
    {
        $this->IATA_Application = $iATA_Application;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get Owner value
     * @return string|null
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * Set Owner value
     * @param string $owner
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setOwner($owner = null)
    {
        $this->Owner = $owner;
        return $this;
    }
    /**
     * Get RefundForm value
     * @return string|null
     */
    public function getRefundForm()
    {
        return $this->RefundForm;
    }
    /**
     * Set RefundForm value
     * @param string $refundForm
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setRefundForm($refundForm = null)
    {
        $this->RefundForm = $refundForm;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get SegmentJourneyCouponInd value
     * @return string|null
     */
    public function getSegmentJourneyCouponInd()
    {
        return $this->SegmentJourneyCouponInd;
    }
    /**
     * Set SegmentJourneyCouponInd value
     * @param string $segmentJourneyCouponInd
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setSegmentJourneyCouponInd($segmentJourneyCouponInd = null)
    {
        $this->SegmentJourneyCouponInd = $segmentJourneyCouponInd;
        return $this;
    }
    /**
     * Get ApproximateTotalCharge value
     * @return \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge[]|null
     */
    public function getApproximateTotalCharge()
    {
        return $this->ApproximateTotalCharge;
    }
    /**
     * Set ApproximateTotalCharge value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge[] $approximateTotalCharge
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function setApproximateTotalCharge(array $approximateTotalCharge = array())
    {
        $this->ApproximateTotalCharge = $approximateTotalCharge;
        return $this;
    }
    /**
     * Add item to ApproximateTotalCharge value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge $item
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public function addToApproximateTotalCharge(\Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge $item)
    {
        $this->ApproximateTotalCharge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
