<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCharge Structs
 * @subpackage Structs
 */
class VehicleCharge extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the vehicle charge amount.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Amount;
    /**
     * The ChargeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ChargeDetails
     */
    public $ChargeDetails;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Commission
     */
    public $Commission;
    /**
     * The Mileage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public $Mileage;
    /**
     * The DropOffCharge
     * Meta informations extracted from the WSDL
     * - documentation: "DropOffCharge" is used to return drop off charge amount.
     * - use: optional
     * @var string
     */
    public $DropOffCharge;
    /**
     * The GuaranteeInd
     * Meta informations extracted from the WSDL
     * - documentation: "GuaranteedInd" is used to return the type of guarantee associated with the vehicle rental.
     * - use: optional
     * @var string
     */
    public $GuaranteeInd;
    /**
     * Constructor method for VehicleCharge
     * @uses VehicleCharge::setAmount()
     * @uses VehicleCharge::setChargeDetails()
     * @uses VehicleCharge::setCommission()
     * @uses VehicleCharge::setMileage()
     * @uses VehicleCharge::setDropOffCharge()
     * @uses VehicleCharge::setGuaranteeInd()
     * @param string[] $amount
     * @param \Sabre\EnhancedAirBook\Structs\ChargeDetails $chargeDetails
     * @param \Sabre\EnhancedAirBook\Structs\Commission $commission
     * @param \Sabre\EnhancedAirBook\Structs\Mileage $mileage
     * @param string $dropOffCharge
     * @param string $guaranteeInd
     */
    public function __construct(array $amount = array(), \Sabre\EnhancedAirBook\Structs\ChargeDetails $chargeDetails = null, \Sabre\EnhancedAirBook\Structs\Commission $commission = null, \Sabre\EnhancedAirBook\Structs\Mileage $mileage = null, $dropOffCharge = null, $guaranteeInd = null)
    {
        $this
            ->setAmount($amount)
            ->setChargeDetails($chargeDetails)
            ->setCommission($commission)
            ->setMileage($mileage)
            ->setDropOffCharge($dropOffCharge)
            ->setGuaranteeInd($guaranteeInd);
    }
    /**
     * Get Amount value
     * @return string[]|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @throws \InvalidArgumentException
     * @param string[] $amount
     * @return \Sabre\EnhancedAirBook\Structs\VehicleCharge
     */
    public function setAmount(array $amount = array())
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Add item to Amount value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\VehicleCharge
     */
    public function addToAmount($item)
    {
        $this->Amount[] = $item;
        return $this;
    }
    /**
     * Get ChargeDetails value
     * @return \Sabre\EnhancedAirBook\Structs\ChargeDetails|null
     */
    public function getChargeDetails()
    {
        return $this->ChargeDetails;
    }
    /**
     * Set ChargeDetails value
     * @param \Sabre\EnhancedAirBook\Structs\ChargeDetails $chargeDetails
     * @return \Sabre\EnhancedAirBook\Structs\VehicleCharge
     */
    public function setChargeDetails(\Sabre\EnhancedAirBook\Structs\ChargeDetails $chargeDetails = null)
    {
        $this->ChargeDetails = $chargeDetails;
        return $this;
    }
    /**
     * Get Commission value
     * @return \Sabre\EnhancedAirBook\Structs\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \Sabre\EnhancedAirBook\Structs\Commission $commission
     * @return \Sabre\EnhancedAirBook\Structs\VehicleCharge
     */
    public function setCommission(\Sabre\EnhancedAirBook\Structs\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get Mileage value
     * @return \Sabre\EnhancedAirBook\Structs\Mileage|null
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param \Sabre\EnhancedAirBook\Structs\Mileage $mileage
     * @return \Sabre\EnhancedAirBook\Structs\VehicleCharge
     */
    public function setMileage(\Sabre\EnhancedAirBook\Structs\Mileage $mileage = null)
    {
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get DropOffCharge value
     * @return string|null
     */
    public function getDropOffCharge()
    {
        return $this->DropOffCharge;
    }
    /**
     * Set DropOffCharge value
     * @param string $dropOffCharge
     * @return \Sabre\EnhancedAirBook\Structs\VehicleCharge
     */
    public function setDropOffCharge($dropOffCharge = null)
    {
        $this->DropOffCharge = $dropOffCharge;
        return $this;
    }
    /**
     * Get GuaranteeInd value
     * @return string|null
     */
    public function getGuaranteeInd()
    {
        return $this->GuaranteeInd;
    }
    /**
     * Set GuaranteeInd value
     * @param string $guaranteeInd
     * @return \Sabre\EnhancedAirBook\Structs\VehicleCharge
     */
    public function setGuaranteeInd($guaranteeInd = null)
    {
        $this->GuaranteeInd = $guaranteeInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\VehicleCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
