<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxInfo Structs
 * @subpackage Structs
 */
class TaxInfo extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Taxes
     */
    public $Taxes;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $RPH;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $Total;
    /**
     * Constructor method for TaxInfo
     * @uses TaxInfo::setTaxes()
     * @uses TaxInfo::setRPH()
     * @uses TaxInfo::setTotal()
     * @param \Sabre\EnhancedAirBook\Structs\Taxes $taxes
     * @param int $rPH
     * @param float $total
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Taxes $taxes = null, $rPH = null, $total = null)
    {
        $this
            ->setTaxes($taxes)
            ->setRPH($rPH)
            ->setTotal($total);
    }
    /**
     * Get Taxes value
     * @return \Sabre\EnhancedAirBook\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\EnhancedAirBook\Structs\Taxes $taxes
     * @return \Sabre\EnhancedAirBook\Structs\TaxInfo
     */
    public function setTaxes(\Sabre\EnhancedAirBook\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \Sabre\EnhancedAirBook\Structs\TaxInfo
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \Sabre\EnhancedAirBook\Structs\TaxInfo
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\TaxInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
