<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureLine Structs
 * @subpackage Structs
 */
class SignatureLine extends AbstractStructBase
{
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return PQ signature line-related information.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Banner
     * Meta informations extracted from the WSDL
     * - documentation: "Banner" is used to return miscellaneous PQ banner-related information.
     * - use: optional
     * @var string
     */
    public $Banner;
    /**
     * The CommissionAmount
     * Meta informations extracted from the WSDL
     * - documentation: "CommissionAmount" is used to return the commission amount if applicable.
     * - use: optional
     * @var string
     */
    public $CommissionAmount;
    /**
     * The CommissionID
     * Meta informations extracted from the WSDL
     * - documentation: "CommissionID" is used to return the commission ID if applicable.
     * - use: optional
     * @var string
     */
    public $CommissionID;
    /**
     * The ExpirationDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "ExpirationDateTime" is used to return the PQ record expiration date/time.
     * - use: optional
     * @var string
     */
    public $ExpirationDateTime;
    /**
     * The PQR_Ind
     * Meta informations extracted from the WSDL
     * - documentation: "PQR_Ind" is used to indicate that the PQ record is a PQ Reissue versus a regular PQ record.
     * - use: optional
     * @var string
     */
    public $PQR_Ind;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - documentation: "Source" is used to return the pricing source associated with the particular PQ record.
     * - use: optional
     * @var string
     */
    public $Source;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the PQ record status.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for SignatureLine
     * @uses SignatureLine::setText()
     * @uses SignatureLine::setBanner()
     * @uses SignatureLine::setCommissionAmount()
     * @uses SignatureLine::setCommissionID()
     * @uses SignatureLine::setExpirationDateTime()
     * @uses SignatureLine::setPQR_Ind()
     * @uses SignatureLine::setSource()
     * @uses SignatureLine::setStatus()
     * @param string $text
     * @param string $banner
     * @param string $commissionAmount
     * @param string $commissionID
     * @param string $expirationDateTime
     * @param string $pQR_Ind
     * @param string $source
     * @param string $status
     */
    public function __construct($text = null, $banner = null, $commissionAmount = null, $commissionID = null, $expirationDateTime = null, $pQR_Ind = null, $source = null, $status = null)
    {
        $this
            ->setText($text)
            ->setBanner($banner)
            ->setCommissionAmount($commissionAmount)
            ->setCommissionID($commissionID)
            ->setExpirationDateTime($expirationDateTime)
            ->setPQR_Ind($pQR_Ind)
            ->setSource($source)
            ->setStatus($status);
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Banner value
     * @return string|null
     */
    public function getBanner()
    {
        return $this->Banner;
    }
    /**
     * Set Banner value
     * @param string $banner
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public function setBanner($banner = null)
    {
        $this->Banner = $banner;
        return $this;
    }
    /**
     * Get CommissionAmount value
     * @return string|null
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param string $commissionAmount
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
    /**
     * Get CommissionID value
     * @return string|null
     */
    public function getCommissionID()
    {
        return $this->CommissionID;
    }
    /**
     * Set CommissionID value
     * @param string $commissionID
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public function setCommissionID($commissionID = null)
    {
        $this->CommissionID = $commissionID;
        return $this;
    }
    /**
     * Get ExpirationDateTime value
     * @return string|null
     */
    public function getExpirationDateTime()
    {
        return $this->ExpirationDateTime;
    }
    /**
     * Set ExpirationDateTime value
     * @param string $expirationDateTime
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public function setExpirationDateTime($expirationDateTime = null)
    {
        $this->ExpirationDateTime = $expirationDateTime;
        return $this;
    }
    /**
     * Get PQR_Ind value
     * @return string|null
     */
    public function getPQR_Ind()
    {
        return $this->PQR_Ind;
    }
    /**
     * Set PQR_Ind value
     * @param string $pQR_Ind
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public function setPQR_Ind($pQR_Ind = null)
    {
        $this->PQR_Ind = $pQR_Ind;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public function setSource($source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
