<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Summary version of the RoomTypeType, initially created for the Travel Itinerary Message set.
 * @subpackage Structs
 */
class RoomType extends AbstractStructBase
{
    /**
     * The RoomTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Specfic system room type code, ex: A1K, A1Q etc.
     * - minOccurs: 0
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The NumberOfUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShortText;
    /**
     * Constructor method for RoomType
     * @uses RoomType::setRoomTypeCode()
     * @uses RoomType::setNumberOfUnits()
     * @uses RoomType::setShortText()
     * @param string $roomTypeCode
     * @param int $numberOfUnits
     * @param string $shortText
     */
    public function __construct($roomTypeCode = null, $numberOfUnits = null, $shortText = null)
    {
        $this
            ->setRoomTypeCode($roomTypeCode)
            ->setNumberOfUnits($numberOfUnits)
            ->setShortText($shortText);
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \Sabre\EnhancedAirBook\Structs\RoomType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \Sabre\EnhancedAirBook\Structs\RoomType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\EnhancedAirBook\Structs\RoomType
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\RoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
