<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedisplayReservation Structs
 * @subpackage Structs
 */
class RedisplayReservation extends AbstractStructBase
{
    /**
     * The NumAttempts
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $NumAttempts;
    /**
     * The WaitInterval
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $WaitInterval;
    /**
     * The UnmaskCreditCard
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $UnmaskCreditCard;
    /**
     * Constructor method for RedisplayReservation
     * @uses RedisplayReservation::setNumAttempts()
     * @uses RedisplayReservation::setWaitInterval()
     * @uses RedisplayReservation::setUnmaskCreditCard()
     * @param string $numAttempts
     * @param string $waitInterval
     * @param bool $unmaskCreditCard
     */
    public function __construct($numAttempts = null, $waitInterval = null, $unmaskCreditCard = null)
    {
        $this
            ->setNumAttempts($numAttempts)
            ->setWaitInterval($waitInterval)
            ->setUnmaskCreditCard($unmaskCreditCard);
    }
    /**
     * Get NumAttempts value
     * @return string
     */
    public function getNumAttempts()
    {
        return $this->NumAttempts;
    }
    /**
     * Set NumAttempts value
     * @param string $numAttempts
     * @return \Sabre\EnhancedAirBook\Structs\RedisplayReservation
     */
    public function setNumAttempts($numAttempts = null)
    {
        $this->NumAttempts = $numAttempts;
        return $this;
    }
    /**
     * Get WaitInterval value
     * @return string|null
     */
    public function getWaitInterval()
    {
        return $this->WaitInterval;
    }
    /**
     * Set WaitInterval value
     * @param string $waitInterval
     * @return \Sabre\EnhancedAirBook\Structs\RedisplayReservation
     */
    public function setWaitInterval($waitInterval = null)
    {
        $this->WaitInterval = $waitInterval;
        return $this;
    }
    /**
     * Get UnmaskCreditCard value
     * @return bool|null
     */
    public function getUnmaskCreditCard()
    {
        return $this->UnmaskCreditCard;
    }
    /**
     * Set UnmaskCreditCard value
     * @param bool $unmaskCreditCard
     * @return \Sabre\EnhancedAirBook\Structs\RedisplayReservation
     */
    public function setUnmaskCreditCard($unmaskCreditCard = null)
    {
        $this->UnmaskCreditCard = $unmaskCreditCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\RedisplayReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
