<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate Structs
 * @subpackage Structs
 */
class Rate extends AbstractStructBase
{
    /**
     * The AdditionalGuestAmounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AdditionalGuestAmounts
     */
    public $AdditionalGuestAmounts;
    /**
     * The HotelRateDescripton
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\HotelRateDescripton
     */
    public $HotelRateDescripton;
    /**
     * The HotelTotalPricing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\HotelTotalPricing
     */
    public $HotelTotalPricing;
    /**
     * The RateAccessCodeBooked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\RateAccessCodeBooked
     */
    public $RateAccessCodeBooked;
    /**
     * The RateAccessCodeRequested
     * Meta informations extracted from the WSDL
     * - documentation: "RateAccessCodeRequested" is used to return rate access code requested details for a particular hotel if applicable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateAccessCodeRequested;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the rate amount.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the currency code associated with the rate amount.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DCS_AuxRateCode
     * Meta informations extracted from the WSDL
     * - documentation: "DCS_AuxRateCode" is used to return the DCS rate code associated with the particular hotel reservation if applicable.
     * - use: optional
     * @var string
     */
    public $DCS_AuxRateCode;
    /**
     * The RoomTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: "RoomTypeCode" is used to return the rate type code associated with the particular hotel reservation.
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * Constructor method for Rate
     * @uses Rate::setAdditionalGuestAmounts()
     * @uses Rate::setHotelRateDescripton()
     * @uses Rate::setHotelTotalPricing()
     * @uses Rate::setRateAccessCodeBooked()
     * @uses Rate::setRateAccessCodeRequested()
     * @uses Rate::setAmount()
     * @uses Rate::setCurrencyCode()
     * @uses Rate::setDCS_AuxRateCode()
     * @uses Rate::setRoomTypeCode()
     * @param \Sabre\EnhancedAirBook\Structs\AdditionalGuestAmounts $additionalGuestAmounts
     * @param \Sabre\EnhancedAirBook\Structs\HotelRateDescripton $hotelRateDescripton
     * @param \Sabre\EnhancedAirBook\Structs\HotelTotalPricing $hotelTotalPricing
     * @param \Sabre\EnhancedAirBook\Structs\RateAccessCodeBooked $rateAccessCodeBooked
     * @param string $rateAccessCodeRequested
     * @param string $amount
     * @param string $currencyCode
     * @param string $dCS_AuxRateCode
     * @param string $roomTypeCode
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\AdditionalGuestAmounts $additionalGuestAmounts = null, \Sabre\EnhancedAirBook\Structs\HotelRateDescripton $hotelRateDescripton = null, \Sabre\EnhancedAirBook\Structs\HotelTotalPricing $hotelTotalPricing = null, \Sabre\EnhancedAirBook\Structs\RateAccessCodeBooked $rateAccessCodeBooked = null, $rateAccessCodeRequested = null, $amount = null, $currencyCode = null, $dCS_AuxRateCode = null, $roomTypeCode = null)
    {
        $this
            ->setAdditionalGuestAmounts($additionalGuestAmounts)
            ->setHotelRateDescripton($hotelRateDescripton)
            ->setHotelTotalPricing($hotelTotalPricing)
            ->setRateAccessCodeBooked($rateAccessCodeBooked)
            ->setRateAccessCodeRequested($rateAccessCodeRequested)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDCS_AuxRateCode($dCS_AuxRateCode)
            ->setRoomTypeCode($roomTypeCode);
    }
    /**
     * Get AdditionalGuestAmounts value
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalGuestAmounts|null
     */
    public function getAdditionalGuestAmounts()
    {
        return $this->AdditionalGuestAmounts;
    }
    /**
     * Set AdditionalGuestAmounts value
     * @param \Sabre\EnhancedAirBook\Structs\AdditionalGuestAmounts $additionalGuestAmounts
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setAdditionalGuestAmounts(\Sabre\EnhancedAirBook\Structs\AdditionalGuestAmounts $additionalGuestAmounts = null)
    {
        $this->AdditionalGuestAmounts = $additionalGuestAmounts;
        return $this;
    }
    /**
     * Get HotelRateDescripton value
     * @return \Sabre\EnhancedAirBook\Structs\HotelRateDescripton|null
     */
    public function getHotelRateDescripton()
    {
        return $this->HotelRateDescripton;
    }
    /**
     * Set HotelRateDescripton value
     * @param \Sabre\EnhancedAirBook\Structs\HotelRateDescripton $hotelRateDescripton
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setHotelRateDescripton(\Sabre\EnhancedAirBook\Structs\HotelRateDescripton $hotelRateDescripton = null)
    {
        $this->HotelRateDescripton = $hotelRateDescripton;
        return $this;
    }
    /**
     * Get HotelTotalPricing value
     * @return \Sabre\EnhancedAirBook\Structs\HotelTotalPricing|null
     */
    public function getHotelTotalPricing()
    {
        return $this->HotelTotalPricing;
    }
    /**
     * Set HotelTotalPricing value
     * @param \Sabre\EnhancedAirBook\Structs\HotelTotalPricing $hotelTotalPricing
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setHotelTotalPricing(\Sabre\EnhancedAirBook\Structs\HotelTotalPricing $hotelTotalPricing = null)
    {
        $this->HotelTotalPricing = $hotelTotalPricing;
        return $this;
    }
    /**
     * Get RateAccessCodeBooked value
     * @return \Sabre\EnhancedAirBook\Structs\RateAccessCodeBooked|null
     */
    public function getRateAccessCodeBooked()
    {
        return $this->RateAccessCodeBooked;
    }
    /**
     * Set RateAccessCodeBooked value
     * @param \Sabre\EnhancedAirBook\Structs\RateAccessCodeBooked $rateAccessCodeBooked
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setRateAccessCodeBooked(\Sabre\EnhancedAirBook\Structs\RateAccessCodeBooked $rateAccessCodeBooked = null)
    {
        $this->RateAccessCodeBooked = $rateAccessCodeBooked;
        return $this;
    }
    /**
     * Get RateAccessCodeRequested value
     * @return string|null
     */
    public function getRateAccessCodeRequested()
    {
        return $this->RateAccessCodeRequested;
    }
    /**
     * Set RateAccessCodeRequested value
     * @param string $rateAccessCodeRequested
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setRateAccessCodeRequested($rateAccessCodeRequested = null)
    {
        $this->RateAccessCodeRequested = $rateAccessCodeRequested;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DCS_AuxRateCode value
     * @return string|null
     */
    public function getDCS_AuxRateCode()
    {
        return $this->DCS_AuxRateCode;
    }
    /**
     * Set DCS_AuxRateCode value
     * @param string $dCS_AuxRateCode
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setDCS_AuxRateCode($dCS_AuxRateCode = null)
    {
        $this->DCS_AuxRateCode = $dCS_AuxRateCode;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Rate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
