<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItinerary Structs
 * @subpackage Structs
 */
class PricedItinerary extends AbstractStructBase
{
    /**
     * The AirItineraryPricingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo
     */
    public $AirItineraryPricingInfo;
    /**
     * The AlternativePricing
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AlternativePricing;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MultiTicket
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $MultiTicket;
    /**
     * The MultiTicketShortText
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MultiTicketShortText;
    /**
     * The ServiceFeeAmount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ServiceFeeAmount;
    /**
     * The ServiceFeeCurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ServiceFeeCurrencyCode;
    /**
     * The ServiceFeeTax
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ServiceFeeTax;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TotalAmount;
    /**
     * The NetTicketingInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\NetTicketingInfo
     */
    public $NetTicketingInfo;
    /**
     * The DeletedBy
     * Meta informations extracted from the WSDL
     * - documentation: "DeletedBy" is used to return deletion information associated with the particular price quote if applicable.
     * - use: optional
     * @var string
     */
    public $DeletedBy;
    /**
     * The DisplayOnly
     * Meta informations extracted from the WSDL
     * - documentation: "DisplayOnly" is used to indicate that the global net remit-related data is display only.
     * - use: optional
     * @var bool
     */
    public $DisplayOnly;
    /**
     * The InputMessage
     * Meta informations extracted from the WSDL
     * - documentation: "InputMessage" is used to return the host command associated with the particular price quote.
     * - use: optional
     * @var string
     */
    public $InputMessage;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference place holder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - documentation: "StatusCode" is used to return the status code associated with the particular price quote. -->
     * - use: optional
     * @var string
     */
    public $StatusCode;
    /**
     * The TaxExempt
     * Meta informations extracted from the WSDL
     * - documentation: "TaxExempt" is used to indicate whether or not the particular priced itinerary is classified as tax exempt
     * - use: optional
     * @var bool
     */
    public $TaxExempt;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - documentation: "ValidatingCarrier" is used to return validating carrier-related information associated with the particular price quote.
     * - use: optional
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * The StoredDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "StoredDateTime" is used to return a date when data were stored in PQ.
     * - use: optional
     * @var string
     */
    public $StoredDateTime;
    /**
     * Constructor method for PricedItinerary
     * @uses PricedItinerary::setAirItineraryPricingInfo()
     * @uses PricedItinerary::setAlternativePricing()
     * @uses PricedItinerary::setCurrencyCode()
     * @uses PricedItinerary::setMultiTicket()
     * @uses PricedItinerary::setMultiTicketShortText()
     * @uses PricedItinerary::setServiceFeeAmount()
     * @uses PricedItinerary::setServiceFeeCurrencyCode()
     * @uses PricedItinerary::setServiceFeeTax()
     * @uses PricedItinerary::setTotalAmount()
     * @uses PricedItinerary::setNetTicketingInfo()
     * @uses PricedItinerary::setDeletedBy()
     * @uses PricedItinerary::setDisplayOnly()
     * @uses PricedItinerary::setInputMessage()
     * @uses PricedItinerary::setRPH()
     * @uses PricedItinerary::setStatusCode()
     * @uses PricedItinerary::setTaxExempt()
     * @uses PricedItinerary::setValidatingCarrier()
     * @uses PricedItinerary::setStoredDateTime()
     * @param \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo $airItineraryPricingInfo
     * @param string $alternativePricing
     * @param string $currencyCode
     * @param bool $multiTicket
     * @param string $multiTicketShortText
     * @param string $serviceFeeAmount
     * @param string $serviceFeeCurrencyCode
     * @param string $serviceFeeTax
     * @param string $totalAmount
     * @param \Sabre\EnhancedAirBook\Structs\NetTicketingInfo $netTicketingInfo
     * @param string $deletedBy
     * @param bool $displayOnly
     * @param string $inputMessage
     * @param string $rPH
     * @param string $statusCode
     * @param bool $taxExempt
     * @param string $validatingCarrier
     * @param string $storedDateTime
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo $airItineraryPricingInfo = null, $alternativePricing = null, $currencyCode = null, $multiTicket = null, $multiTicketShortText = null, $serviceFeeAmount = null, $serviceFeeCurrencyCode = null, $serviceFeeTax = null, $totalAmount = null, \Sabre\EnhancedAirBook\Structs\NetTicketingInfo $netTicketingInfo = null, $deletedBy = null, $displayOnly = null, $inputMessage = null, $rPH = null, $statusCode = null, $taxExempt = null, $validatingCarrier = null, $storedDateTime = null)
    {
        $this
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setAlternativePricing($alternativePricing)
            ->setCurrencyCode($currencyCode)
            ->setMultiTicket($multiTicket)
            ->setMultiTicketShortText($multiTicketShortText)
            ->setServiceFeeAmount($serviceFeeAmount)
            ->setServiceFeeCurrencyCode($serviceFeeCurrencyCode)
            ->setServiceFeeTax($serviceFeeTax)
            ->setTotalAmount($totalAmount)
            ->setNetTicketingInfo($netTicketingInfo)
            ->setDeletedBy($deletedBy)
            ->setDisplayOnly($displayOnly)
            ->setInputMessage($inputMessage)
            ->setRPH($rPH)
            ->setStatusCode($statusCode)
            ->setTaxExempt($taxExempt)
            ->setValidatingCarrier($validatingCarrier)
            ->setStoredDateTime($storedDateTime);
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo $airItineraryPricingInfo
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setAirItineraryPricingInfo(\Sabre\EnhancedAirBook\Structs\AirItineraryPricingInfo $airItineraryPricingInfo = null)
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Get AlternativePricing value
     * @return string|null
     */
    public function getAlternativePricing()
    {
        return $this->AlternativePricing;
    }
    /**
     * Set AlternativePricing value
     * @param string $alternativePricing
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setAlternativePricing($alternativePricing = null)
    {
        $this->AlternativePricing = $alternativePricing;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MultiTicket value
     * @return bool|null
     */
    public function getMultiTicket()
    {
        return $this->MultiTicket;
    }
    /**
     * Set MultiTicket value
     * @param bool $multiTicket
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setMultiTicket($multiTicket = null)
    {
        $this->MultiTicket = $multiTicket;
        return $this;
    }
    /**
     * Get MultiTicketShortText value
     * @return string|null
     */
    public function getMultiTicketShortText()
    {
        return $this->MultiTicketShortText;
    }
    /**
     * Set MultiTicketShortText value
     * @param string $multiTicketShortText
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setMultiTicketShortText($multiTicketShortText = null)
    {
        $this->MultiTicketShortText = $multiTicketShortText;
        return $this;
    }
    /**
     * Get ServiceFeeAmount value
     * @return string|null
     */
    public function getServiceFeeAmount()
    {
        return $this->ServiceFeeAmount;
    }
    /**
     * Set ServiceFeeAmount value
     * @param string $serviceFeeAmount
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setServiceFeeAmount($serviceFeeAmount = null)
    {
        $this->ServiceFeeAmount = $serviceFeeAmount;
        return $this;
    }
    /**
     * Get ServiceFeeCurrencyCode value
     * @return string|null
     */
    public function getServiceFeeCurrencyCode()
    {
        return $this->ServiceFeeCurrencyCode;
    }
    /**
     * Set ServiceFeeCurrencyCode value
     * @param string $serviceFeeCurrencyCode
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setServiceFeeCurrencyCode($serviceFeeCurrencyCode = null)
    {
        $this->ServiceFeeCurrencyCode = $serviceFeeCurrencyCode;
        return $this;
    }
    /**
     * Get ServiceFeeTax value
     * @return string|null
     */
    public function getServiceFeeTax()
    {
        return $this->ServiceFeeTax;
    }
    /**
     * Set ServiceFeeTax value
     * @param string $serviceFeeTax
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setServiceFeeTax($serviceFeeTax = null)
    {
        $this->ServiceFeeTax = $serviceFeeTax;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get NetTicketingInfo value
     * @return \Sabre\EnhancedAirBook\Structs\NetTicketingInfo|null
     */
    public function getNetTicketingInfo()
    {
        return $this->NetTicketingInfo;
    }
    /**
     * Set NetTicketingInfo value
     * @param \Sabre\EnhancedAirBook\Structs\NetTicketingInfo $netTicketingInfo
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setNetTicketingInfo(\Sabre\EnhancedAirBook\Structs\NetTicketingInfo $netTicketingInfo = null)
    {
        $this->NetTicketingInfo = $netTicketingInfo;
        return $this;
    }
    /**
     * Get DeletedBy value
     * @return string|null
     */
    public function getDeletedBy()
    {
        return $this->DeletedBy;
    }
    /**
     * Set DeletedBy value
     * @param string $deletedBy
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setDeletedBy($deletedBy = null)
    {
        $this->DeletedBy = $deletedBy;
        return $this;
    }
    /**
     * Get DisplayOnly value
     * @return bool|null
     */
    public function getDisplayOnly()
    {
        return $this->DisplayOnly;
    }
    /**
     * Set DisplayOnly value
     * @param bool $displayOnly
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setDisplayOnly($displayOnly = null)
    {
        $this->DisplayOnly = $displayOnly;
        return $this;
    }
    /**
     * Get InputMessage value
     * @return string|null
     */
    public function getInputMessage()
    {
        return $this->InputMessage;
    }
    /**
     * Set InputMessage value
     * @param string $inputMessage
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setInputMessage($inputMessage = null)
    {
        $this->InputMessage = $inputMessage;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get TaxExempt value
     * @return bool|null
     */
    public function getTaxExempt()
    {
        return $this->TaxExempt;
    }
    /**
     * Set TaxExempt value
     * @param bool $taxExempt
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setTaxExempt($taxExempt = null)
    {
        $this->TaxExempt = $taxExempt;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Get StoredDateTime value
     * @return string|null
     */
    public function getStoredDateTime()
    {
        return $this->StoredDateTime;
    }
    /**
     * Set StoredDateTime value
     * @param string $storedDateTime
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public function setStoredDateTime($storedDateTime = null)
    {
        $this->StoredDateTime = $storedDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PricedItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
