<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTC_FareBreakdown Structs
 * @subpackage Structs
 */
class PTC_FareBreakdown extends AbstractStructBase
{
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 1
     * - pattern: [A-Z0-9]+(/[A-Z0-9]+)?
     * @var string
     */
    public $FareBasisCode;
    /**
     * The PassengerFare
     * @var \Sabre\EnhancedAirBook\Structs\PassengerFare
     */
    public $PassengerFare;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\PassengerType
     */
    public $PassengerType;
    /**
     * The BrandedFareInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BrandedFareInformation
     */
    public $BrandedFareInformation;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Cabin;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareBasis[]
     */
    public $FareBasis;
    /**
     * The FreeBaggageAllowance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FreeBaggageAllowance;
    /**
     * The Surcharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Surcharges[]
     */
    public $Surcharges;
    /**
     * The NetRemits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\NetRemits
     */
    public $NetRemits;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Endorsements
     */
    public $Endorsements;
    /**
     * The FareCalculation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareCalculation
     */
    public $FareCalculation;
    /**
     * The FareSource
     * Meta informations extracted from the WSDL
     * - documentation: "FareSource" is used to return the fare source.
     * - minOccurs: 0
     * @var string
     */
    public $FareSource;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The FareComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareComponent[]
     */
    public $FareComponent;
    /**
     * The ResTicketingRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: "ResTicketingRestrictions" is used to return last day to purchase-related information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ResTicketingRestrictions;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\TourCode
     */
    public $TourCode;
    /**
     * Constructor method for PTC_FareBreakdown
     * @uses PTC_FareBreakdown::setFareBasisCode()
     * @uses PTC_FareBreakdown::setPassengerFare()
     * @uses PTC_FareBreakdown::setPassengerType()
     * @uses PTC_FareBreakdown::setBrandedFareInformation()
     * @uses PTC_FareBreakdown::setCabin()
     * @uses PTC_FareBreakdown::setFareBasis()
     * @uses PTC_FareBreakdown::setFreeBaggageAllowance()
     * @uses PTC_FareBreakdown::setSurcharges()
     * @uses PTC_FareBreakdown::setNetRemits()
     * @uses PTC_FareBreakdown::setEndorsements()
     * @uses PTC_FareBreakdown::setFareCalculation()
     * @uses PTC_FareBreakdown::setFareSource()
     * @uses PTC_FareBreakdown::setFlightSegment()
     * @uses PTC_FareBreakdown::setFareComponent()
     * @uses PTC_FareBreakdown::setResTicketingRestrictions()
     * @uses PTC_FareBreakdown::setTourCode()
     * @param string $fareBasisCode
     * @param \Sabre\EnhancedAirBook\Structs\PassengerFare $passengerFare
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType $passengerType
     * @param \Sabre\EnhancedAirBook\Structs\BrandedFareInformation $brandedFareInformation
     * @param string $cabin
     * @param \Sabre\EnhancedAirBook\Structs\FareBasis[] $fareBasis
     * @param string $freeBaggageAllowance
     * @param \Sabre\EnhancedAirBook\Structs\Surcharges[] $surcharges
     * @param \Sabre\EnhancedAirBook\Structs\NetRemits $netRemits
     * @param \Sabre\EnhancedAirBook\Structs\Endorsements $endorsements
     * @param \Sabre\EnhancedAirBook\Structs\FareCalculation $fareCalculation
     * @param string $fareSource
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment[] $flightSegment
     * @param \Sabre\EnhancedAirBook\Structs\FareComponent[] $fareComponent
     * @param string[] $resTicketingRestrictions
     * @param \Sabre\EnhancedAirBook\Structs\TourCode $tourCode
     */
    public function __construct($fareBasisCode = null, \Sabre\EnhancedAirBook\Structs\PassengerFare $passengerFare = null, \Sabre\EnhancedAirBook\Structs\PassengerType $passengerType = null, \Sabre\EnhancedAirBook\Structs\BrandedFareInformation $brandedFareInformation = null, $cabin = null, array $fareBasis = array(), $freeBaggageAllowance = null, array $surcharges = array(), \Sabre\EnhancedAirBook\Structs\NetRemits $netRemits = null, \Sabre\EnhancedAirBook\Structs\Endorsements $endorsements = null, \Sabre\EnhancedAirBook\Structs\FareCalculation $fareCalculation = null, $fareSource = null, array $flightSegment = array(), array $fareComponent = array(), array $resTicketingRestrictions = array(), \Sabre\EnhancedAirBook\Structs\TourCode $tourCode = null)
    {
        $this
            ->setFareBasisCode($fareBasisCode)
            ->setPassengerFare($passengerFare)
            ->setPassengerType($passengerType)
            ->setBrandedFareInformation($brandedFareInformation)
            ->setCabin($cabin)
            ->setFareBasis($fareBasis)
            ->setFreeBaggageAllowance($freeBaggageAllowance)
            ->setSurcharges($surcharges)
            ->setNetRemits($netRemits)
            ->setEndorsements($endorsements)
            ->setFareCalculation($fareCalculation)
            ->setFareSource($fareSource)
            ->setFlightSegment($flightSegment)
            ->setFareComponent($fareComponent)
            ->setResTicketingRestrictions($resTicketingRestrictions)
            ->setTourCode($tourCode);
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get PassengerFare value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerFare|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * Set PassengerFare value
     * @param \Sabre\EnhancedAirBook\Structs\PassengerFare $passengerFare
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setPassengerFare(\Sabre\EnhancedAirBook\Structs\PassengerFare $passengerFare = null)
    {
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return \Sabre\EnhancedAirBook\Structs\PassengerType|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param \Sabre\EnhancedAirBook\Structs\PassengerType $passengerType
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setPassengerType(\Sabre\EnhancedAirBook\Structs\PassengerType $passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get BrandedFareInformation value
     * @return \Sabre\EnhancedAirBook\Structs\BrandedFareInformation|null
     */
    public function getBrandedFareInformation()
    {
        return $this->BrandedFareInformation;
    }
    /**
     * Set BrandedFareInformation value
     * @param \Sabre\EnhancedAirBook\Structs\BrandedFareInformation $brandedFareInformation
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setBrandedFareInformation(\Sabre\EnhancedAirBook\Structs\BrandedFareInformation $brandedFareInformation = null)
    {
        $this->BrandedFareInformation = $brandedFareInformation;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setCabin($cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\EnhancedAirBook\Structs\FareBasis[]|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FareBasis[] $fareBasis
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setFareBasis(array $fareBasis = array())
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Add item to FareBasis value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FareBasis $item
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function addToFareBasis(\Sabre\EnhancedAirBook\Structs\FareBasis $item)
    {
        $this->FareBasis[] = $item;
        return $this;
    }
    /**
     * Get FreeBaggageAllowance value
     * @return string|null
     */
    public function getFreeBaggageAllowance()
    {
        return $this->FreeBaggageAllowance;
    }
    /**
     * Set FreeBaggageAllowance value
     * @param string $freeBaggageAllowance
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setFreeBaggageAllowance($freeBaggageAllowance = null)
    {
        $this->FreeBaggageAllowance = $freeBaggageAllowance;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \Sabre\EnhancedAirBook\Structs\Surcharges[]|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Surcharges[] $surcharges
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setSurcharges(array $surcharges = array())
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
    /**
     * Add item to Surcharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Surcharges $item
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function addToSurcharges(\Sabre\EnhancedAirBook\Structs\Surcharges $item)
    {
        $this->Surcharges[] = $item;
        return $this;
    }
    /**
     * Get NetRemits value
     * @return \Sabre\EnhancedAirBook\Structs\NetRemits|null
     */
    public function getNetRemits()
    {
        return $this->NetRemits;
    }
    /**
     * Set NetRemits value
     * @param \Sabre\EnhancedAirBook\Structs\NetRemits $netRemits
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setNetRemits(\Sabre\EnhancedAirBook\Structs\NetRemits $netRemits = null)
    {
        $this->NetRemits = $netRemits;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \Sabre\EnhancedAirBook\Structs\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \Sabre\EnhancedAirBook\Structs\Endorsements $endorsements
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setEndorsements(\Sabre\EnhancedAirBook\Structs\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get FareCalculation value
     * @return \Sabre\EnhancedAirBook\Structs\FareCalculation|null
     */
    public function getFareCalculation()
    {
        return $this->FareCalculation;
    }
    /**
     * Set FareCalculation value
     * @param \Sabre\EnhancedAirBook\Structs\FareCalculation $fareCalculation
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setFareCalculation(\Sabre\EnhancedAirBook\Structs\FareCalculation $fareCalculation = null)
    {
        $this->FareCalculation = $fareCalculation;
        return $this;
    }
    /**
     * Get FareSource value
     * @return string|null
     */
    public function getFareSource()
    {
        return $this->FareSource;
    }
    /**
     * Set FareSource value
     * @param string $fareSource
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setFareSource($fareSource = null)
    {
        $this->FareSource = $fareSource;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FlightSegment $item
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function addToFlightSegment(\Sabre\EnhancedAirBook\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get FareComponent value
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent[]|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * Set FareComponent value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FareComponent[] $fareComponent
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setFareComponent(array $fareComponent = array())
    {
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Add item to FareComponent value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\FareComponent $item
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function addToFareComponent(\Sabre\EnhancedAirBook\Structs\FareComponent $item)
    {
        $this->FareComponent[] = $item;
        return $this;
    }
    /**
     * Get ResTicketingRestrictions value
     * @return string[]|null
     */
    public function getResTicketingRestrictions()
    {
        return $this->ResTicketingRestrictions;
    }
    /**
     * Set ResTicketingRestrictions value
     * @throws \InvalidArgumentException
     * @param string[] $resTicketingRestrictions
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setResTicketingRestrictions(array $resTicketingRestrictions = array())
    {
        $this->ResTicketingRestrictions = $resTicketingRestrictions;
        return $this;
    }
    /**
     * Add item to ResTicketingRestrictions value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function addToResTicketingRestrictions($item)
    {
        $this->ResTicketingRestrictions[] = $item;
        return $this;
    }
    /**
     * Get TourCode value
     * @return \Sabre\EnhancedAirBook\Structs\TourCode|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param \Sabre\EnhancedAirBook\Structs\TourCode $tourCode
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public function setTourCode(\Sabre\EnhancedAirBook\Structs\TourCode $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\PTC_FareBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
