<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetRemit Structs
 * @subpackage Structs
 */
class NetRemit extends AbstractStructBase
{
    /**
     * The CAR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CAR
     */
    public $CAR;
    /**
     * The Cash
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Cash
     */
    public $Cash;
    /**
     * The Credit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Credit
     */
    public $Credit;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * Constructor method for NetRemit
     * @uses NetRemit::setCAR()
     * @uses NetRemit::setCash()
     * @uses NetRemit::setCredit()
     * @uses NetRemit::setCode()
     * @uses NetRemit::setText()
     * @param \Sabre\EnhancedAirBook\Structs\CAR $cAR
     * @param \Sabre\EnhancedAirBook\Structs\Cash $cash
     * @param \Sabre\EnhancedAirBook\Structs\Credit $credit
     * @param string $code
     * @param string $text
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\CAR $cAR = null, \Sabre\EnhancedAirBook\Structs\Cash $cash = null, \Sabre\EnhancedAirBook\Structs\Credit $credit = null, $code = null, $text = null)
    {
        $this
            ->setCAR($cAR)
            ->setCash($cash)
            ->setCredit($credit)
            ->setCode($code)
            ->setText($text);
    }
    /**
     * Get CAR value
     * @return \Sabre\EnhancedAirBook\Structs\CAR|null
     */
    public function getCAR()
    {
        return $this->CAR;
    }
    /**
     * Set CAR value
     * @param \Sabre\EnhancedAirBook\Structs\CAR $cAR
     * @return \Sabre\EnhancedAirBook\Structs\NetRemit
     */
    public function setCAR(\Sabre\EnhancedAirBook\Structs\CAR $cAR = null)
    {
        $this->CAR = $cAR;
        return $this;
    }
    /**
     * Get Cash value
     * @return \Sabre\EnhancedAirBook\Structs\Cash|null
     */
    public function getCash()
    {
        return $this->Cash;
    }
    /**
     * Set Cash value
     * @param \Sabre\EnhancedAirBook\Structs\Cash $cash
     * @return \Sabre\EnhancedAirBook\Structs\NetRemit
     */
    public function setCash(\Sabre\EnhancedAirBook\Structs\Cash $cash = null)
    {
        $this->Cash = $cash;
        return $this;
    }
    /**
     * Get Credit value
     * @return \Sabre\EnhancedAirBook\Structs\Credit|null
     */
    public function getCredit()
    {
        return $this->Credit;
    }
    /**
     * Set Credit value
     * @param \Sabre\EnhancedAirBook\Structs\Credit $credit
     * @return \Sabre\EnhancedAirBook\Structs\NetRemit
     */
    public function setCredit(\Sabre\EnhancedAirBook\Structs\Credit $credit = null)
    {
        $this->Credit = $credit;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\EnhancedAirBook\Structs\NetRemit
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\EnhancedAirBook\Structs\NetRemit
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\NetRemit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
