<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscInformation Structs
 * @subpackage Structs
 */
class MiscInformation extends AbstractStructBase
{
    /**
     * The BaggageInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BaggageInfo
     */
    public $BaggageInfo;
    /**
     * The HeaderInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\HeaderInformation[]
     */
    public $HeaderInformation;
    /**
     * The SolutionInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SolutionInformation[]
     */
    public $SolutionInformation;
    /**
     * The OptionalCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\OptionalCharges[]
     */
    public $OptionalCharges;
    /**
     * The BaggageFees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BaggageFees
     */
    public $BaggageFees;
    /**
     * The GlobalNetRemit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\GlobalNetRemit[]
     */
    public $GlobalNetRemit;
    /**
     * The SignatureLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SignatureLine[]
     */
    public $SignatureLine;
    /**
     * The TicketingFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\TicketingFees[]
     */
    public $TicketingFees;
    /**
     * Constructor method for MiscInformation
     * @uses MiscInformation::setBaggageInfo()
     * @uses MiscInformation::setHeaderInformation()
     * @uses MiscInformation::setSolutionInformation()
     * @uses MiscInformation::setOptionalCharges()
     * @uses MiscInformation::setBaggageFees()
     * @uses MiscInformation::setGlobalNetRemit()
     * @uses MiscInformation::setSignatureLine()
     * @uses MiscInformation::setTicketingFees()
     * @param \Sabre\EnhancedAirBook\Structs\BaggageInfo $baggageInfo
     * @param \Sabre\EnhancedAirBook\Structs\HeaderInformation[] $headerInformation
     * @param \Sabre\EnhancedAirBook\Structs\SolutionInformation[] $solutionInformation
     * @param \Sabre\EnhancedAirBook\Structs\OptionalCharges[] $optionalCharges
     * @param \Sabre\EnhancedAirBook\Structs\BaggageFees $baggageFees
     * @param \Sabre\EnhancedAirBook\Structs\GlobalNetRemit[] $globalNetRemit
     * @param \Sabre\EnhancedAirBook\Structs\SignatureLine[] $signatureLine
     * @param \Sabre\EnhancedAirBook\Structs\TicketingFees[] $ticketingFees
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\BaggageInfo $baggageInfo = null, array $headerInformation = array(), array $solutionInformation = array(), array $optionalCharges = array(), \Sabre\EnhancedAirBook\Structs\BaggageFees $baggageFees = null, array $globalNetRemit = array(), array $signatureLine = array(), array $ticketingFees = array())
    {
        $this
            ->setBaggageInfo($baggageInfo)
            ->setHeaderInformation($headerInformation)
            ->setSolutionInformation($solutionInformation)
            ->setOptionalCharges($optionalCharges)
            ->setBaggageFees($baggageFees)
            ->setGlobalNetRemit($globalNetRemit)
            ->setSignatureLine($signatureLine)
            ->setTicketingFees($ticketingFees);
    }
    /**
     * Get BaggageInfo value
     * @return \Sabre\EnhancedAirBook\Structs\BaggageInfo|null
     */
    public function getBaggageInfo()
    {
        return $this->BaggageInfo;
    }
    /**
     * Set BaggageInfo value
     * @param \Sabre\EnhancedAirBook\Structs\BaggageInfo $baggageInfo
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function setBaggageInfo(\Sabre\EnhancedAirBook\Structs\BaggageInfo $baggageInfo = null)
    {
        $this->BaggageInfo = $baggageInfo;
        return $this;
    }
    /**
     * Get HeaderInformation value
     * @return \Sabre\EnhancedAirBook\Structs\HeaderInformation[]|null
     */
    public function getHeaderInformation()
    {
        return $this->HeaderInformation;
    }
    /**
     * Set HeaderInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\HeaderInformation[] $headerInformation
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function setHeaderInformation(array $headerInformation = array())
    {
        $this->HeaderInformation = $headerInformation;
        return $this;
    }
    /**
     * Add item to HeaderInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\HeaderInformation $item
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function addToHeaderInformation(\Sabre\EnhancedAirBook\Structs\HeaderInformation $item)
    {
        $this->HeaderInformation[] = $item;
        return $this;
    }
    /**
     * Get SolutionInformation value
     * @return \Sabre\EnhancedAirBook\Structs\SolutionInformation[]|null
     */
    public function getSolutionInformation()
    {
        return $this->SolutionInformation;
    }
    /**
     * Set SolutionInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\SolutionInformation[] $solutionInformation
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function setSolutionInformation(array $solutionInformation = array())
    {
        $this->SolutionInformation = $solutionInformation;
        return $this;
    }
    /**
     * Add item to SolutionInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\SolutionInformation $item
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function addToSolutionInformation(\Sabre\EnhancedAirBook\Structs\SolutionInformation $item)
    {
        $this->SolutionInformation[] = $item;
        return $this;
    }
    /**
     * Get OptionalCharges value
     * @return \Sabre\EnhancedAirBook\Structs\OptionalCharges[]|null
     */
    public function getOptionalCharges()
    {
        return $this->OptionalCharges;
    }
    /**
     * Set OptionalCharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\OptionalCharges[] $optionalCharges
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function setOptionalCharges(array $optionalCharges = array())
    {
        $this->OptionalCharges = $optionalCharges;
        return $this;
    }
    /**
     * Add item to OptionalCharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\OptionalCharges $item
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function addToOptionalCharges(\Sabre\EnhancedAirBook\Structs\OptionalCharges $item)
    {
        $this->OptionalCharges[] = $item;
        return $this;
    }
    /**
     * Get BaggageFees value
     * @return \Sabre\EnhancedAirBook\Structs\BaggageFees|null
     */
    public function getBaggageFees()
    {
        return $this->BaggageFees;
    }
    /**
     * Set BaggageFees value
     * @param \Sabre\EnhancedAirBook\Structs\BaggageFees $baggageFees
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function setBaggageFees(\Sabre\EnhancedAirBook\Structs\BaggageFees $baggageFees = null)
    {
        $this->BaggageFees = $baggageFees;
        return $this;
    }
    /**
     * Get GlobalNetRemit value
     * @return \Sabre\EnhancedAirBook\Structs\GlobalNetRemit[]|null
     */
    public function getGlobalNetRemit()
    {
        return $this->GlobalNetRemit;
    }
    /**
     * Set GlobalNetRemit value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\GlobalNetRemit[] $globalNetRemit
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function setGlobalNetRemit(array $globalNetRemit = array())
    {
        $this->GlobalNetRemit = $globalNetRemit;
        return $this;
    }
    /**
     * Add item to GlobalNetRemit value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\GlobalNetRemit $item
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function addToGlobalNetRemit(\Sabre\EnhancedAirBook\Structs\GlobalNetRemit $item)
    {
        $this->GlobalNetRemit[] = $item;
        return $this;
    }
    /**
     * Get SignatureLine value
     * @return \Sabre\EnhancedAirBook\Structs\SignatureLine[]|null
     */
    public function getSignatureLine()
    {
        return $this->SignatureLine;
    }
    /**
     * Set SignatureLine value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\SignatureLine[] $signatureLine
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function setSignatureLine(array $signatureLine = array())
    {
        $this->SignatureLine = $signatureLine;
        return $this;
    }
    /**
     * Add item to SignatureLine value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\SignatureLine $item
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function addToSignatureLine(\Sabre\EnhancedAirBook\Structs\SignatureLine $item)
    {
        $this->SignatureLine[] = $item;
        return $this;
    }
    /**
     * Get TicketingFees value
     * @return \Sabre\EnhancedAirBook\Structs\TicketingFees[]|null
     */
    public function getTicketingFees()
    {
        return $this->TicketingFees;
    }
    /**
     * Set TicketingFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\TicketingFees[] $ticketingFees
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function setTicketingFees(array $ticketingFees = array())
    {
        $this->TicketingFees = $ticketingFees;
        return $this;
    }
    /**
     * Add item to TicketingFees value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\TicketingFees $item
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public function addToTicketingFees(\Sabre\EnhancedAirBook\Structs\TicketingFees $item)
    {
        $this->TicketingFees[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\MiscInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
