<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mileage Structs
 * @subpackage Structs
 */
class Mileage extends AbstractStructBase
{
    /**
     * The ExtraAllowanceInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExtraAllowanceInd;
    /**
     * The MileageExclusionInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MileageExclusionInd;
    /**
     * The MileageReductionPTInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MileageReductionPTInd;
    /**
     * The MileageEqualizationInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MileageEqualizationInd;
    /**
     * The MileageSymbol
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MileageSymbol;
    /**
     * The MileageSurchargeInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MileageSurchargeInd;
    /**
     * The HIPConstructionCityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $HIPConstructionCityCode;
    /**
     * The HIPCityCodes
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $HIPCityCodes;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the currency code associated with mileage charges.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ExtraMileageCharge
     * Meta informations extracted from the WSDL
     * - documentation: "ExtraMileageCharge" is used to return extra mileage charge-related information.
     * - use: optional
     * @var string
     */
    public $ExtraMileageCharge;
    /**
     * The UnitOfMeasure
     * Meta informations extracted from the WSDL
     * - documentation: "UnitOfMeasure" is used to return the unit of measurement, i.e. miles or kilometers.
     * - use: optional
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * Constructor method for Mileage
     * @uses Mileage::setExtraAllowanceInd()
     * @uses Mileage::setMileageExclusionInd()
     * @uses Mileage::setMileageReductionPTInd()
     * @uses Mileage::setMileageEqualizationInd()
     * @uses Mileage::setMileageSymbol()
     * @uses Mileage::setMileageSurchargeInd()
     * @uses Mileage::setHIPConstructionCityCode()
     * @uses Mileage::setHIPCityCodes()
     * @uses Mileage::setCurrencyCode()
     * @uses Mileage::setExtraMileageCharge()
     * @uses Mileage::setUnitOfMeasure()
     * @param string $extraAllowanceInd
     * @param string $mileageExclusionInd
     * @param string $mileageReductionPTInd
     * @param string $mileageEqualizationInd
     * @param string $mileageSymbol
     * @param string $mileageSurchargeInd
     * @param string $hIPConstructionCityCode
     * @param string $hIPCityCodes
     * @param string $currencyCode
     * @param string $extraMileageCharge
     * @param string $unitOfMeasure
     */
    public function __construct($extraAllowanceInd = null, $mileageExclusionInd = null, $mileageReductionPTInd = null, $mileageEqualizationInd = null, $mileageSymbol = null, $mileageSurchargeInd = null, $hIPConstructionCityCode = null, $hIPCityCodes = null, $currencyCode = null, $extraMileageCharge = null, $unitOfMeasure = null)
    {
        $this
            ->setExtraAllowanceInd($extraAllowanceInd)
            ->setMileageExclusionInd($mileageExclusionInd)
            ->setMileageReductionPTInd($mileageReductionPTInd)
            ->setMileageEqualizationInd($mileageEqualizationInd)
            ->setMileageSymbol($mileageSymbol)
            ->setMileageSurchargeInd($mileageSurchargeInd)
            ->setHIPConstructionCityCode($hIPConstructionCityCode)
            ->setHIPCityCodes($hIPCityCodes)
            ->setCurrencyCode($currencyCode)
            ->setExtraMileageCharge($extraMileageCharge)
            ->setUnitOfMeasure($unitOfMeasure);
    }
    /**
     * Get ExtraAllowanceInd value
     * @return string|null
     */
    public function getExtraAllowanceInd()
    {
        return $this->ExtraAllowanceInd;
    }
    /**
     * Set ExtraAllowanceInd value
     * @param string $extraAllowanceInd
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setExtraAllowanceInd($extraAllowanceInd = null)
    {
        $this->ExtraAllowanceInd = $extraAllowanceInd;
        return $this;
    }
    /**
     * Get MileageExclusionInd value
     * @return string|null
     */
    public function getMileageExclusionInd()
    {
        return $this->MileageExclusionInd;
    }
    /**
     * Set MileageExclusionInd value
     * @param string $mileageExclusionInd
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setMileageExclusionInd($mileageExclusionInd = null)
    {
        $this->MileageExclusionInd = $mileageExclusionInd;
        return $this;
    }
    /**
     * Get MileageReductionPTInd value
     * @return string|null
     */
    public function getMileageReductionPTInd()
    {
        return $this->MileageReductionPTInd;
    }
    /**
     * Set MileageReductionPTInd value
     * @param string $mileageReductionPTInd
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setMileageReductionPTInd($mileageReductionPTInd = null)
    {
        $this->MileageReductionPTInd = $mileageReductionPTInd;
        return $this;
    }
    /**
     * Get MileageEqualizationInd value
     * @return string|null
     */
    public function getMileageEqualizationInd()
    {
        return $this->MileageEqualizationInd;
    }
    /**
     * Set MileageEqualizationInd value
     * @param string $mileageEqualizationInd
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setMileageEqualizationInd($mileageEqualizationInd = null)
    {
        $this->MileageEqualizationInd = $mileageEqualizationInd;
        return $this;
    }
    /**
     * Get MileageSymbol value
     * @return string|null
     */
    public function getMileageSymbol()
    {
        return $this->MileageSymbol;
    }
    /**
     * Set MileageSymbol value
     * @param string $mileageSymbol
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setMileageSymbol($mileageSymbol = null)
    {
        $this->MileageSymbol = $mileageSymbol;
        return $this;
    }
    /**
     * Get MileageSurchargeInd value
     * @return string|null
     */
    public function getMileageSurchargeInd()
    {
        return $this->MileageSurchargeInd;
    }
    /**
     * Set MileageSurchargeInd value
     * @param string $mileageSurchargeInd
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setMileageSurchargeInd($mileageSurchargeInd = null)
    {
        $this->MileageSurchargeInd = $mileageSurchargeInd;
        return $this;
    }
    /**
     * Get HIPConstructionCityCode value
     * @return string|null
     */
    public function getHIPConstructionCityCode()
    {
        return $this->HIPConstructionCityCode;
    }
    /**
     * Set HIPConstructionCityCode value
     * @param string $hIPConstructionCityCode
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setHIPConstructionCityCode($hIPConstructionCityCode = null)
    {
        $this->HIPConstructionCityCode = $hIPConstructionCityCode;
        return $this;
    }
    /**
     * Get HIPCityCodes value
     * @return string|null
     */
    public function getHIPCityCodes()
    {
        return $this->HIPCityCodes;
    }
    /**
     * Set HIPCityCodes value
     * @param string $hIPCityCodes
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setHIPCityCodes($hIPCityCodes = null)
    {
        $this->HIPCityCodes = $hIPCityCodes;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ExtraMileageCharge value
     * @return string|null
     */
    public function getExtraMileageCharge()
    {
        return $this->ExtraMileageCharge;
    }
    /**
     * Set ExtraMileageCharge value
     * @param string $extraMileageCharge
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setExtraMileageCharge($extraMileageCharge = null)
    {
        $this->ExtraMileageCharge = $extraMileageCharge;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Mileage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
