<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageHeader Structs
 * @subpackage Structs
 */
class MessageHeader extends AbstractStructBase
{
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - ref: tns:From
     * @var \Sabre\EnhancedAirBook\Structs\From
     */
    public $From;
    /**
     * The To
     * Meta informations extracted from the WSDL
     * - ref: tns:To
     * @var \Sabre\EnhancedAirBook\Structs\To
     */
    public $To;
    /**
     * The CPAId
     * Meta informations extracted from the WSDL
     * - ref: tns:CPAId
     * - minLength: 1
     * @var string
     */
    public $CPAId;
    /**
     * The ConversationId
     * Meta informations extracted from the WSDL
     * - ref: tns:ConversationId
     * - minLength: 1
     * @var string
     */
    public $ConversationId;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - ref: tns:Service
     * @var \Sabre\EnhancedAirBook\Structs\Service
     */
    public $Service;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - ref: tns:Action
     * - minLength: 1
     * @var string
     */
    public $Action;
    /**
     * The MessageData
     * Meta informations extracted from the WSDL
     * - ref: tns:MessageData
     * @var \Sabre\EnhancedAirBook\Structs\MessageData
     */
    public $MessageData;
    /**
     * The DuplicateElimination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DuplicateElimination
     * @var mixed
     */
    public $DuplicateElimination;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \Sabre\EnhancedAirBook\Structs\Description[]
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var \Sabre\EnhancedAirBook\Structs\ID
     */
    public $id;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for MessageHeader
     * @uses MessageHeader::setFrom()
     * @uses MessageHeader::setTo()
     * @uses MessageHeader::setCPAId()
     * @uses MessageHeader::setConversationId()
     * @uses MessageHeader::setService()
     * @uses MessageHeader::setAction()
     * @uses MessageHeader::setMessageData()
     * @uses MessageHeader::setDuplicateElimination()
     * @uses MessageHeader::setDescription()
     * @uses MessageHeader::setAny()
     * @uses MessageHeader::setId()
     * @uses MessageHeader::setVersion()
     * @param \Sabre\EnhancedAirBook\Structs\From $from
     * @param \Sabre\EnhancedAirBook\Structs\To $to
     * @param string $cPAId
     * @param string $conversationId
     * @param \Sabre\EnhancedAirBook\Structs\Service $service
     * @param string $action
     * @param \Sabre\EnhancedAirBook\Structs\MessageData $messageData
     * @param mixed $duplicateElimination
     * @param \Sabre\EnhancedAirBook\Structs\Description[] $description
     * @param \DOMDocument $any
     * @param \Sabre\EnhancedAirBook\Structs\ID $id
     * @param string $version
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\From $from = null, \Sabre\EnhancedAirBook\Structs\To $to = null, $cPAId = null, $conversationId = null, \Sabre\EnhancedAirBook\Structs\Service $service = null, $action = null, \Sabre\EnhancedAirBook\Structs\MessageData $messageData = null, $duplicateElimination = null, array $description = array(), \DOMDocument $any = null, \Sabre\EnhancedAirBook\Structs\ID $id = null, $version = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setCPAId($cPAId)
            ->setConversationId($conversationId)
            ->setService($service)
            ->setAction($action)
            ->setMessageData($messageData)
            ->setDuplicateElimination($duplicateElimination)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get From value
     * @return \Sabre\EnhancedAirBook\Structs\From|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param \Sabre\EnhancedAirBook\Structs\From $from
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setFrom(\Sabre\EnhancedAirBook\Structs\From $from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return \Sabre\EnhancedAirBook\Structs\To|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param \Sabre\EnhancedAirBook\Structs\To $to
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setTo(\Sabre\EnhancedAirBook\Structs\To $to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get CPAId value
     * @return string|null
     */
    public function getCPAId()
    {
        return $this->CPAId;
    }
    /**
     * Set CPAId value
     * @param string $cPAId
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setCPAId($cPAId = null)
    {
        $this->CPAId = $cPAId;
        return $this;
    }
    /**
     * Get ConversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->ConversationId;
    }
    /**
     * Set ConversationId value
     * @param string $conversationId
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setConversationId($conversationId = null)
    {
        $this->ConversationId = $conversationId;
        return $this;
    }
    /**
     * Get Service value
     * @return \Sabre\EnhancedAirBook\Structs\Service|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Sabre\EnhancedAirBook\Structs\Service $service
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setService(\Sabre\EnhancedAirBook\Structs\Service $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setAction($action = null)
    {
        $this->Action = $action;
        return $this;
    }
    /**
     * Get MessageData value
     * @return \Sabre\EnhancedAirBook\Structs\MessageData|null
     */
    public function getMessageData()
    {
        return $this->MessageData;
    }
    /**
     * Set MessageData value
     * @param \Sabre\EnhancedAirBook\Structs\MessageData $messageData
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setMessageData(\Sabre\EnhancedAirBook\Structs\MessageData $messageData = null)
    {
        $this->MessageData = $messageData;
        return $this;
    }
    /**
     * Get DuplicateElimination value
     * @return mixed|null
     */
    public function getDuplicateElimination()
    {
        return $this->DuplicateElimination;
    }
    /**
     * Set DuplicateElimination value
     * @param mixed $duplicateElimination
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setDuplicateElimination($duplicateElimination = null)
    {
        $this->DuplicateElimination = $duplicateElimination;
        return $this;
    }
    /**
     * Get Description value
     * @return \Sabre\EnhancedAirBook\Structs\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Description[] $description
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Description $item
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function addToDescription(\Sabre\EnhancedAirBook\Structs\Description $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\EnhancedAirBook\Structs\MessageHeader::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get id value
     * @return \Sabre\EnhancedAirBook\Structs\ID|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \Sabre\EnhancedAirBook\Structs\ID $id
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setId(\Sabre\EnhancedAirBook\Structs\ID $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\MessageHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
