<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingAirline Structs
 * @subpackage Structs
 */
class MarketingAirline extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return the marketing airline code associated with the particular flight segment. | "Code" is used to return the marketing airline code associated with the particular flight segment. | "Code" is used to return the
     * marketing airline code associated with the particular vehicle segment.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: "FlightNumber" is used to return the marketing airline flight number associated with the particular flight segment. | "FlightNumber" is used to return the flight number associated with the particular flight segment. | "FlightNumber"
     * is used to return the flight number associated with the particular vehicle segment.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The Banner
     * Meta informations extracted from the WSDL
     * - documentation: "MarketingAirline/Banner" is used to return the marketing airline name.
     * - minOccurs: 0
     * @var string
     */
    public $Banner;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * Constructor method for MarketingAirline
     * @uses MarketingAirline::setCode()
     * @uses MarketingAirline::setFlightNumber()
     * @uses MarketingAirline::setBanner()
     * @uses MarketingAirline::setResBookDesigCode()
     * @param string $code
     * @param string $flightNumber
     * @param string $banner
     * @param string $resBookDesigCode
     */
    public function __construct($code = null, $flightNumber = null, $banner = null, $resBookDesigCode = null)
    {
        $this
            ->setCode($code)
            ->setFlightNumber($flightNumber)
            ->setBanner($banner)
            ->setResBookDesigCode($resBookDesigCode);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\EnhancedAirBook\Structs\MarketingAirline
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\EnhancedAirBook\Structs\MarketingAirline
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Banner value
     * @return string|null
     */
    public function getBanner()
    {
        return $this->Banner;
    }
    /**
     * Set Banner value
     * @param string $banner
     * @return \Sabre\EnhancedAirBook\Structs\MarketingAirline
     */
    public function setBanner($banner = null)
    {
        $this->Banner = $banner;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\EnhancedAirBook\Structs\MarketingAirline
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\MarketingAirline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
