<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelType Structs
 * @subpackage Structs
 */
class HotelType extends AbstractStructBase
{
    /**
     * The Reservation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Reservation
     */
    public $Reservation;
    /**
     * The AdditionalInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AdditionalInformation
     */
    public $AdditionalInformation;
    /**
     * The SegmentText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SegmentText;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - documentation: Used for Numeric values, from 1 to 9999 inclusive.
     * - maxInclusive: 99999
     * - minInclusive: 0
     * @var int
     */
    public $index;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - documentation: Identifies sequence number of Itinerary
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for HotelType
     * @uses HotelType::setReservation()
     * @uses HotelType::setAdditionalInformation()
     * @uses HotelType::setSegmentText()
     * @uses HotelType::setIndex()
     * @uses HotelType::setId()
     * @uses HotelType::setSequence()
     * @param \Sabre\EnhancedAirBook\Structs\Reservation $reservation
     * @param \Sabre\EnhancedAirBook\Structs\AdditionalInformation $additionalInformation
     * @param string $segmentText
     * @param int $index
     * @param string $id
     * @param int $sequence
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Reservation $reservation = null, \Sabre\EnhancedAirBook\Structs\AdditionalInformation $additionalInformation = null, $segmentText = null, $index = null, $id = null, $sequence = null)
    {
        $this
            ->setReservation($reservation)
            ->setAdditionalInformation($additionalInformation)
            ->setSegmentText($segmentText)
            ->setIndex($index)
            ->setId($id)
            ->setSequence($sequence);
    }
    /**
     * Get Reservation value
     * @return \Sabre\EnhancedAirBook\Structs\Reservation|null
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * Set Reservation value
     * @param \Sabre\EnhancedAirBook\Structs\Reservation $reservation
     * @return \Sabre\EnhancedAirBook\Structs\HotelType
     */
    public function setReservation(\Sabre\EnhancedAirBook\Structs\Reservation $reservation = null)
    {
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \Sabre\EnhancedAirBook\Structs\AdditionalInformation|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param \Sabre\EnhancedAirBook\Structs\AdditionalInformation $additionalInformation
     * @return \Sabre\EnhancedAirBook\Structs\HotelType
     */
    public function setAdditionalInformation(\Sabre\EnhancedAirBook\Structs\AdditionalInformation $additionalInformation = null)
    {
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get SegmentText value
     * @return string|null
     */
    public function getSegmentText()
    {
        return $this->SegmentText;
    }
    /**
     * Set SegmentText value
     * @param string $segmentText
     * @return \Sabre\EnhancedAirBook\Structs\HotelType
     */
    public function setSegmentText($segmentText = null)
    {
        $this->SegmentText = $segmentText;
        return $this;
    }
    /**
     * Get index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \Sabre\EnhancedAirBook\Structs\HotelType
     */
    public function setIndex($index = null)
    {
        $this->index = $index;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\EnhancedAirBook\Structs\HotelType
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \Sabre\EnhancedAirBook\Structs\HotelType
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\HotelType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
