<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestCounts Structs
 * Meta informations extracted from the WSDL
 * - documentation: Number of guests associated with this reservation.
 * @subpackage Structs
 */
class GuestCounts extends AbstractStructBase
{
    /**
     * The GuestCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GuestCount;
    /**
     * The ExtraGuestCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ExtraGuestCount;
    /**
     * The RollAwayCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $RollAwayCount;
    /**
     * The CribCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $CribCount;
    /**
     * The ReserveUnderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ReserveUnderName;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Name;
    /**
     * Constructor method for GuestCounts
     * @uses GuestCounts::setGuestCount()
     * @uses GuestCounts::setExtraGuestCount()
     * @uses GuestCounts::setRollAwayCount()
     * @uses GuestCounts::setCribCount()
     * @uses GuestCounts::setReserveUnderName()
     * @uses GuestCounts::setName()
     * @param int $guestCount
     * @param string[] $extraGuestCount
     * @param string[] $rollAwayCount
     * @param int[] $cribCount
     * @param string[] $reserveUnderName
     * @param string[] $name
     */
    public function __construct($guestCount = null, array $extraGuestCount = array(), array $rollAwayCount = array(), array $cribCount = array(), array $reserveUnderName = array(), array $name = array())
    {
        $this
            ->setGuestCount($guestCount)
            ->setExtraGuestCount($extraGuestCount)
            ->setRollAwayCount($rollAwayCount)
            ->setCribCount($cribCount)
            ->setReserveUnderName($reserveUnderName)
            ->setName($name);
    }
    /**
     * Get GuestCount value
     * @return int|null
     */
    public function getGuestCount()
    {
        return $this->GuestCount;
    }
    /**
     * Set GuestCount value
     * @param int $guestCount
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function setGuestCount($guestCount = null)
    {
        $this->GuestCount = $guestCount;
        return $this;
    }
    /**
     * Get ExtraGuestCount value
     * @return string[]|null
     */
    public function getExtraGuestCount()
    {
        return $this->ExtraGuestCount;
    }
    /**
     * Set ExtraGuestCount value
     * @throws \InvalidArgumentException
     * @param string[] $extraGuestCount
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function setExtraGuestCount(array $extraGuestCount = array())
    {
        $this->ExtraGuestCount = $extraGuestCount;
        return $this;
    }
    /**
     * Add item to ExtraGuestCount value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function addToExtraGuestCount($item)
    {
        $this->ExtraGuestCount[] = $item;
        return $this;
    }
    /**
     * Get RollAwayCount value
     * @return string[]|null
     */
    public function getRollAwayCount()
    {
        return $this->RollAwayCount;
    }
    /**
     * Set RollAwayCount value
     * @throws \InvalidArgumentException
     * @param string[] $rollAwayCount
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function setRollAwayCount(array $rollAwayCount = array())
    {
        $this->RollAwayCount = $rollAwayCount;
        return $this;
    }
    /**
     * Add item to RollAwayCount value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function addToRollAwayCount($item)
    {
        $this->RollAwayCount[] = $item;
        return $this;
    }
    /**
     * Get CribCount value
     * @return int[]|null
     */
    public function getCribCount()
    {
        return $this->CribCount;
    }
    /**
     * Set CribCount value
     * @throws \InvalidArgumentException
     * @param int[] $cribCount
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function setCribCount(array $cribCount = array())
    {
        $this->CribCount = $cribCount;
        return $this;
    }
    /**
     * Add item to CribCount value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function addToCribCount($item)
    {
        $this->CribCount[] = $item;
        return $this;
    }
    /**
     * Get ReserveUnderName value
     * @return string[]|null
     */
    public function getReserveUnderName()
    {
        return $this->ReserveUnderName;
    }
    /**
     * Set ReserveUnderName value
     * @throws \InvalidArgumentException
     * @param string[] $reserveUnderName
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function setReserveUnderName(array $reserveUnderName = array())
    {
        $this->ReserveUnderName = $reserveUnderName;
        return $this;
    }
    /**
     * Add item to ReserveUnderName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function addToReserveUnderName($item)
    {
        $this->ReserveUnderName[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string[]|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @throws \InvalidArgumentException
     * @param string[] $name
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function setName(array $name = array())
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Add item to Name value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public function addToName($item)
    {
        $this->Name[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\GuestCounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
