<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupInfo Structs
 * @subpackage Structs
 */
class GroupInfo extends AbstractStructBase
{
    /**
     * The AssociatedReferenceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\AssociatedReferenceInformation
     */
    public $AssociatedReferenceInformation;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: "Name" is used to return the corporate/group name.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The OriginalNumberOfSeats
     * Meta informations extracted from the WSDL
     * - documentation: "OriginalNumberOfSeats" is used to return the original number of seats requested in the BSG
     * - use: optional
     * @var string
     */
    public $OriginalNumberOfSeats;
    /**
     * The GroupNameNumber
     * Meta informations extracted from the WSDL
     * - documentation: "GroupNameNumber" is used to return the passenger name number in relation to the rest of the group.
     * - use: optional
     * @var string
     */
    public $GroupNameNumber;
    /**
     * The NumSeatsRemaining
     * Meta informations extracted from the WSDL
     * - documentation: "NumSeatsRemaining" is used to return the number of remaining seats.
     * - use: optional
     * @var string
     */
    public $NumSeatsRemaining;
    /**
     * The SoldNumberOfSeats
     * Meta informations extracted from the WSDL
     * - documentation: "SoldNumberOfSeats is used to return the number of seats sold from the BSG"
     * - use: optional
     * @var string
     */
    public $SoldNumberOfSeats;
    /**
     * Constructor method for GroupInfo
     * @uses GroupInfo::setAssociatedReferenceInformation()
     * @uses GroupInfo::setName()
     * @uses GroupInfo::setOriginalNumberOfSeats()
     * @uses GroupInfo::setGroupNameNumber()
     * @uses GroupInfo::setNumSeatsRemaining()
     * @uses GroupInfo::setSoldNumberOfSeats()
     * @param \Sabre\EnhancedAirBook\Structs\AssociatedReferenceInformation $associatedReferenceInformation
     * @param string $name
     * @param string $originalNumberOfSeats
     * @param string $groupNameNumber
     * @param string $numSeatsRemaining
     * @param string $soldNumberOfSeats
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\AssociatedReferenceInformation $associatedReferenceInformation = null, $name = null, $originalNumberOfSeats = null, $groupNameNumber = null, $numSeatsRemaining = null, $soldNumberOfSeats = null)
    {
        $this
            ->setAssociatedReferenceInformation($associatedReferenceInformation)
            ->setName($name)
            ->setOriginalNumberOfSeats($originalNumberOfSeats)
            ->setGroupNameNumber($groupNameNumber)
            ->setNumSeatsRemaining($numSeatsRemaining)
            ->setSoldNumberOfSeats($soldNumberOfSeats);
    }
    /**
     * Get AssociatedReferenceInformation value
     * @return \Sabre\EnhancedAirBook\Structs\AssociatedReferenceInformation|null
     */
    public function getAssociatedReferenceInformation()
    {
        return $this->AssociatedReferenceInformation;
    }
    /**
     * Set AssociatedReferenceInformation value
     * @param \Sabre\EnhancedAirBook\Structs\AssociatedReferenceInformation $associatedReferenceInformation
     * @return \Sabre\EnhancedAirBook\Structs\GroupInfo
     */
    public function setAssociatedReferenceInformation(\Sabre\EnhancedAirBook\Structs\AssociatedReferenceInformation $associatedReferenceInformation = null)
    {
        $this->AssociatedReferenceInformation = $associatedReferenceInformation;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\EnhancedAirBook\Structs\GroupInfo
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get OriginalNumberOfSeats value
     * @return string|null
     */
    public function getOriginalNumberOfSeats()
    {
        return $this->OriginalNumberOfSeats;
    }
    /**
     * Set OriginalNumberOfSeats value
     * @param string $originalNumberOfSeats
     * @return \Sabre\EnhancedAirBook\Structs\GroupInfo
     */
    public function setOriginalNumberOfSeats($originalNumberOfSeats = null)
    {
        $this->OriginalNumberOfSeats = $originalNumberOfSeats;
        return $this;
    }
    /**
     * Get GroupNameNumber value
     * @return string|null
     */
    public function getGroupNameNumber()
    {
        return $this->GroupNameNumber;
    }
    /**
     * Set GroupNameNumber value
     * @param string $groupNameNumber
     * @return \Sabre\EnhancedAirBook\Structs\GroupInfo
     */
    public function setGroupNameNumber($groupNameNumber = null)
    {
        $this->GroupNameNumber = $groupNameNumber;
        return $this;
    }
    /**
     * Get NumSeatsRemaining value
     * @return string|null
     */
    public function getNumSeatsRemaining()
    {
        return $this->NumSeatsRemaining;
    }
    /**
     * Set NumSeatsRemaining value
     * @param string $numSeatsRemaining
     * @return \Sabre\EnhancedAirBook\Structs\GroupInfo
     */
    public function setNumSeatsRemaining($numSeatsRemaining = null)
    {
        $this->NumSeatsRemaining = $numSeatsRemaining;
        return $this;
    }
    /**
     * Get SoldNumberOfSeats value
     * @return string|null
     */
    public function getSoldNumberOfSeats()
    {
        return $this->SoldNumberOfSeats;
    }
    /**
     * Set SoldNumberOfSeats value
     * @param string $soldNumberOfSeats
     * @return \Sabre\EnhancedAirBook\Structs\GroupInfo
     */
    public function setSoldNumberOfSeats($soldNumberOfSeats = null)
    {
        $this->SoldNumberOfSeats = $soldNumberOfSeats;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\GroupInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
