<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment Structs
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The ArrivalAirport
     * @var \Sabre\EnhancedAirBook\Structs\ArrivalAirport
     */
    public $ArrivalAirport;
    /**
     * The DepartureAirport
     * @var \Sabre\EnhancedAirBook\Structs\DepartureAirport
     */
    public $DepartureAirport;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Equipment
     */
    public $Equipment;
    /**
     * The FareBreakInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public $FareBreakInfo;
    /**
     * The HiddenStops
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\HiddenStops
     */
    public $HiddenStops;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\MarketingAirline
     */
    public $MarketingAirline;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\OperatingAirline[]
     */
    public $OperatingAirline;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "DepartureDateTime" is used to return the time and date of flight departure associated with the particular flight segment. "DepartureDateTime" follows this format: MM:DDTHH:MM | "DepartureDateTime" is used to return the scheduled
     * departure date/time associated with the particular flight segment. Please note that updated information is provided via .../Air/UpdatedDepartureTime if applicable. "DepartureDateTime" follows this format: YYYY-MM-DDTHH:MM | DepartureDateTime" is used
     * to return the departure date/time associated with the particular segment. "DepartureDateTime" follows this format: MM:DD
     * - use: optional
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "ArrivalDateTime" is used to return the scheduled arrival date/time associated with the particular flight segment. Please note that updated information is provided via .../Air/UpdatedArrivalTime if applicable. "ArrivalDateTime"
     * follows this format: MM-DDTHH:MM
     * - use: optional
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: "FlightNumber" is used to return the flight number associated with the particular flight segment. | "FlightNumber" is used to return the flight number associated with the particular flight segment. | "FlightNumber" is used to return
     * the flight number associated with the particular segment. | "FlightNumber" is used to return the flight number associated with the particular flight segment.
     * - use: optional
     * @var int
     */
    public $FlightNumber;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: "ResBookDesigCode" is used to return the booking class associated with the particular flight segment. | "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The ForceConnectionInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ForceConnectionInd;
    /**
     * The ForceStopOverInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ForceStopOverInd;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The MarriageGrp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MarriageGrp;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: "NumberInParty" is used to return the number of passengers associated with the particular hotel segment.
     * - use: optional
     * @var string
     */
    public $NumberInParty;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment. | "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The InstantPurchase
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $InstantPurchase;
    /**
     * The eTicket
     * Meta informations extracted from the WSDL
     * - documentation: "eTicket" is used to indicate whether or not the particular flight segment is eTicket-eligible.
     * - use: optional
     * @var bool
     */
    public $eTicket;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the internal order segment number that was used to price the segments. | "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The BaggageAllowance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BaggageAllowance
     */
    public $BaggageAllowance;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\FareBasis
     */
    public $FareBasis;
    /**
     * The ValidityDates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ValidityDates
     */
    public $ValidityDates;
    /**
     * The ConnectionInd
     * Meta informations extracted from the WSDL
     * - documentation: "ConnectionInd" is used to return the connection indicator associated with the particular flight segment. | "ConnectionInd" is used to return the connection indicator associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $ConnectionInd;
    /**
     * The BSG_Record
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BSG_Record
     */
    public $BSG_Record;
    /**
     * The CheckInAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CheckInAirline
     */
    public $CheckInAirline;
    /**
     * The CodeshareRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CodeshareRecord
     */
    public $CodeshareRecord;
    /**
     * The MarketingCodeshareRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\MarketingCodeshareRecord
     */
    public $MarketingCodeshareRecord;
    /**
     * The Meal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Meal[]
     */
    public $Meal;
    /**
     * The OperatingAirlinePricing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\OperatingAirlinePricing
     */
    public $OperatingAirlinePricing;
    /**
     * The OperatingAirlineRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\OperatingAirlineRecord
     */
    public $OperatingAirlineRecord;
    /**
     * The DisclosureCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\DisclosureCarrier
     */
    public $DisclosureCarrier;
    /**
     * The SupplierRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\SupplierRef
     */
    public $SupplierRef;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous free text-based information.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The BSGIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "BSGIndicator" is used to indicate he flight segment has a BSG PNR
     * - minOccurs: 0
     * @var string
     */
    public $BSGIndicator;
    /**
     * The UpdatedArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: "UpdatedArrivalTime" is used to return updated arrival information if applicable. "UpdatedArrivalTime" follows this format: MM-DDTHH:MM
     * - minOccurs: 0
     * @var string
     */
    public $UpdatedArrivalTime;
    /**
     * The UpdatedDepartureTime
     * Meta informations extracted from the WSDL
     * - documentation: "UpdatedDepartureTime" is used to return updated departure information if applicable. "UpdatedDepartureTime" follows this format: MM-DDTHH:MM
     * - minOccurs: 0
     * @var string
     */
    public $UpdatedDepartureTime;
    /**
     * The AirMilesFlown
     * Meta informations extracted from the WSDL
     * - documentation: "AirMilesFlown" is used to return the air miles flown associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $AirMilesFlown;
    /**
     * The DayOfWeekInd
     * Meta informations extracted from the WSDL
     * - documentation: "DayOfWeekInd" is used to return the day of the week indicator.
     * - use: optional
     * @var string
     */
    public $DayOfWeekInd;
    /**
     * The ElapsedTime
     * Meta informations extracted from the WSDL
     * - documentation: "ElapsedTime" is used to return the elapsed time associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $ElapsedTime;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - documentation: "SmokingAllowed" is used to indicate whether or not smoking is permitted on the particular flight segment.
     * - use: optional
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The SpecialMeal
     * Meta informations extracted from the WSDL
     * - documentation: "SpecialMeal" is used to indicate whether or not a special meal is associated with the particular flight segment.
     * - use: optional
     * @var bool
     */
    public $SpecialMeal;
    /**
     * The StopQuantity
     * Meta informations extracted from the WSDL
     * - documentation: "StopQuantity" is used to return the number of stops associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $StopQuantity;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on FlightSegment - @DepartureDateTime, FlightSegment - OriginLocation - @LocationCode.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * The CodeShare
     * Meta informations extracted from the WSDL
     * - documentation: "CodeShare" is used to indicate if this is a codeshare flight.
     * - use: optional
     * @var bool
     */
    public $CodeShare;
    /**
     * The Wetlease
     * Meta informations extracted from the WSDL
     * - documentation: "Wetlease" is used to indicate if this flight is operated as a wetlease flight.
     * - use: optional
     * @var bool
     */
    public $Wetlease;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setArrivalAirport()
     * @uses FlightSegment::setDepartureAirport()
     * @uses FlightSegment::setEquipment()
     * @uses FlightSegment::setFareBreakInfo()
     * @uses FlightSegment::setHiddenStops()
     * @uses FlightSegment::setMarketingAirline()
     * @uses FlightSegment::setOperatingAirline()
     * @uses FlightSegment::setDepartureDateTime()
     * @uses FlightSegment::setArrivalDateTime()
     * @uses FlightSegment::setFlightNumber()
     * @uses FlightSegment::setResBookDesigCode()
     * @uses FlightSegment::setForceConnectionInd()
     * @uses FlightSegment::setForceStopOverInd()
     * @uses FlightSegment::setDestinationLocation()
     * @uses FlightSegment::setMarriageGrp()
     * @uses FlightSegment::setOriginLocation()
     * @uses FlightSegment::setBrandID()
     * @uses FlightSegment::setNumberInParty()
     * @uses FlightSegment::setStatus()
     * @uses FlightSegment::setInstantPurchase()
     * @uses FlightSegment::setETicket()
     * @uses FlightSegment::setSegmentNumber()
     * @uses FlightSegment::setBaggageAllowance()
     * @uses FlightSegment::setFareBasis()
     * @uses FlightSegment::setValidityDates()
     * @uses FlightSegment::setConnectionInd()
     * @uses FlightSegment::setBSG_Record()
     * @uses FlightSegment::setCheckInAirline()
     * @uses FlightSegment::setCodeshareRecord()
     * @uses FlightSegment::setMarketingCodeshareRecord()
     * @uses FlightSegment::setMeal()
     * @uses FlightSegment::setOperatingAirlinePricing()
     * @uses FlightSegment::setOperatingAirlineRecord()
     * @uses FlightSegment::setDisclosureCarrier()
     * @uses FlightSegment::setSupplierRef()
     * @uses FlightSegment::setText()
     * @uses FlightSegment::setBSGIndicator()
     * @uses FlightSegment::setUpdatedArrivalTime()
     * @uses FlightSegment::setUpdatedDepartureTime()
     * @uses FlightSegment::setAirMilesFlown()
     * @uses FlightSegment::setDayOfWeekInd()
     * @uses FlightSegment::setElapsedTime()
     * @uses FlightSegment::setSmokingAllowed()
     * @uses FlightSegment::setSpecialMeal()
     * @uses FlightSegment::setStopQuantity()
     * @uses FlightSegment::setIsPast()
     * @uses FlightSegment::setCodeShare()
     * @uses FlightSegment::setWetlease()
     * @param \Sabre\EnhancedAirBook\Structs\ArrivalAirport $arrivalAirport
     * @param \Sabre\EnhancedAirBook\Structs\DepartureAirport $departureAirport
     * @param \Sabre\EnhancedAirBook\Structs\Equipment $equipment
     * @param \Sabre\EnhancedAirBook\Structs\FareBreakInfo $fareBreakInfo
     * @param \Sabre\EnhancedAirBook\Structs\HiddenStops $hiddenStops
     * @param \Sabre\EnhancedAirBook\Structs\MarketingAirline $marketingAirline
     * @param \Sabre\EnhancedAirBook\Structs\OperatingAirline[] $operatingAirline
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param int $flightNumber
     * @param string $resBookDesigCode
     * @param bool $forceConnectionInd
     * @param bool $forceStopOverInd
     * @param \Sabre\EnhancedAirBook\Structs\DestinationLocation $destinationLocation
     * @param string $marriageGrp
     * @param \Sabre\EnhancedAirBook\Structs\OriginLocation $originLocation
     * @param string $brandID
     * @param string $numberInParty
     * @param string $status
     * @param bool $instantPurchase
     * @param bool $eTicket
     * @param string $segmentNumber
     * @param \Sabre\EnhancedAirBook\Structs\BaggageAllowance $baggageAllowance
     * @param \Sabre\EnhancedAirBook\Structs\FareBasis $fareBasis
     * @param \Sabre\EnhancedAirBook\Structs\ValidityDates $validityDates
     * @param string $connectionInd
     * @param \Sabre\EnhancedAirBook\Structs\BSG_Record $bSG_Record
     * @param \Sabre\EnhancedAirBook\Structs\CheckInAirline $checkInAirline
     * @param \Sabre\EnhancedAirBook\Structs\CodeshareRecord $codeshareRecord
     * @param \Sabre\EnhancedAirBook\Structs\MarketingCodeshareRecord $marketingCodeshareRecord
     * @param \Sabre\EnhancedAirBook\Structs\Meal[] $meal
     * @param \Sabre\EnhancedAirBook\Structs\OperatingAirlinePricing $operatingAirlinePricing
     * @param \Sabre\EnhancedAirBook\Structs\OperatingAirlineRecord $operatingAirlineRecord
     * @param \Sabre\EnhancedAirBook\Structs\DisclosureCarrier $disclosureCarrier
     * @param \Sabre\EnhancedAirBook\Structs\SupplierRef $supplierRef
     * @param string $text
     * @param string $bSGIndicator
     * @param string $updatedArrivalTime
     * @param string $updatedDepartureTime
     * @param string $airMilesFlown
     * @param string $dayOfWeekInd
     * @param string $elapsedTime
     * @param bool $smokingAllowed
     * @param bool $specialMeal
     * @param string $stopQuantity
     * @param bool $isPast
     * @param bool $codeShare
     * @param bool $wetlease
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\ArrivalAirport $arrivalAirport = null, \Sabre\EnhancedAirBook\Structs\DepartureAirport $departureAirport = null, \Sabre\EnhancedAirBook\Structs\Equipment $equipment = null, \Sabre\EnhancedAirBook\Structs\FareBreakInfo $fareBreakInfo = null, \Sabre\EnhancedAirBook\Structs\HiddenStops $hiddenStops = null, \Sabre\EnhancedAirBook\Structs\MarketingAirline $marketingAirline = null, array $operatingAirline = array(), $departureDateTime = null, $arrivalDateTime = null, $flightNumber = null, $resBookDesigCode = null, $forceConnectionInd = null, $forceStopOverInd = null, \Sabre\EnhancedAirBook\Structs\DestinationLocation $destinationLocation = null, $marriageGrp = null, \Sabre\EnhancedAirBook\Structs\OriginLocation $originLocation = null, $brandID = null, $numberInParty = null, $status = null, $instantPurchase = null, $eTicket = null, $segmentNumber = null, \Sabre\EnhancedAirBook\Structs\BaggageAllowance $baggageAllowance = null, \Sabre\EnhancedAirBook\Structs\FareBasis $fareBasis = null, \Sabre\EnhancedAirBook\Structs\ValidityDates $validityDates = null, $connectionInd = null, \Sabre\EnhancedAirBook\Structs\BSG_Record $bSG_Record = null, \Sabre\EnhancedAirBook\Structs\CheckInAirline $checkInAirline = null, \Sabre\EnhancedAirBook\Structs\CodeshareRecord $codeshareRecord = null, \Sabre\EnhancedAirBook\Structs\MarketingCodeshareRecord $marketingCodeshareRecord = null, array $meal = array(), \Sabre\EnhancedAirBook\Structs\OperatingAirlinePricing $operatingAirlinePricing = null, \Sabre\EnhancedAirBook\Structs\OperatingAirlineRecord $operatingAirlineRecord = null, \Sabre\EnhancedAirBook\Structs\DisclosureCarrier $disclosureCarrier = null, \Sabre\EnhancedAirBook\Structs\SupplierRef $supplierRef = null, $text = null, $bSGIndicator = null, $updatedArrivalTime = null, $updatedDepartureTime = null, $airMilesFlown = null, $dayOfWeekInd = null, $elapsedTime = null, $smokingAllowed = null, $specialMeal = null, $stopQuantity = null, $isPast = null, $codeShare = null, $wetlease = null)
    {
        $this
            ->setArrivalAirport($arrivalAirport)
            ->setDepartureAirport($departureAirport)
            ->setEquipment($equipment)
            ->setFareBreakInfo($fareBreakInfo)
            ->setHiddenStops($hiddenStops)
            ->setMarketingAirline($marketingAirline)
            ->setOperatingAirline($operatingAirline)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setFlightNumber($flightNumber)
            ->setResBookDesigCode($resBookDesigCode)
            ->setForceConnectionInd($forceConnectionInd)
            ->setForceStopOverInd($forceStopOverInd)
            ->setDestinationLocation($destinationLocation)
            ->setMarriageGrp($marriageGrp)
            ->setOriginLocation($originLocation)
            ->setBrandID($brandID)
            ->setNumberInParty($numberInParty)
            ->setStatus($status)
            ->setInstantPurchase($instantPurchase)
            ->setETicket($eTicket)
            ->setSegmentNumber($segmentNumber)
            ->setBaggageAllowance($baggageAllowance)
            ->setFareBasis($fareBasis)
            ->setValidityDates($validityDates)
            ->setConnectionInd($connectionInd)
            ->setBSG_Record($bSG_Record)
            ->setCheckInAirline($checkInAirline)
            ->setCodeshareRecord($codeshareRecord)
            ->setMarketingCodeshareRecord($marketingCodeshareRecord)
            ->setMeal($meal)
            ->setOperatingAirlinePricing($operatingAirlinePricing)
            ->setOperatingAirlineRecord($operatingAirlineRecord)
            ->setDisclosureCarrier($disclosureCarrier)
            ->setSupplierRef($supplierRef)
            ->setText($text)
            ->setBSGIndicator($bSGIndicator)
            ->setUpdatedArrivalTime($updatedArrivalTime)
            ->setUpdatedDepartureTime($updatedDepartureTime)
            ->setAirMilesFlown($airMilesFlown)
            ->setDayOfWeekInd($dayOfWeekInd)
            ->setElapsedTime($elapsedTime)
            ->setSmokingAllowed($smokingAllowed)
            ->setSpecialMeal($specialMeal)
            ->setStopQuantity($stopQuantity)
            ->setIsPast($isPast)
            ->setCodeShare($codeShare)
            ->setWetlease($wetlease);
    }
    /**
     * Get ArrivalAirport value
     * @return \Sabre\EnhancedAirBook\Structs\ArrivalAirport|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \Sabre\EnhancedAirBook\Structs\ArrivalAirport $arrivalAirport
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setArrivalAirport(\Sabre\EnhancedAirBook\Structs\ArrivalAirport $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \Sabre\EnhancedAirBook\Structs\DepartureAirport|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \Sabre\EnhancedAirBook\Structs\DepartureAirport $departureAirport
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setDepartureAirport(\Sabre\EnhancedAirBook\Structs\DepartureAirport $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \Sabre\EnhancedAirBook\Structs\Equipment|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \Sabre\EnhancedAirBook\Structs\Equipment $equipment
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setEquipment(\Sabre\EnhancedAirBook\Structs\Equipment $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get FareBreakInfo value
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo|null
     */
    public function getFareBreakInfo()
    {
        return $this->FareBreakInfo;
    }
    /**
     * Set FareBreakInfo value
     * @param \Sabre\EnhancedAirBook\Structs\FareBreakInfo $fareBreakInfo
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setFareBreakInfo(\Sabre\EnhancedAirBook\Structs\FareBreakInfo $fareBreakInfo = null)
    {
        $this->FareBreakInfo = $fareBreakInfo;
        return $this;
    }
    /**
     * Get HiddenStops value
     * @return \Sabre\EnhancedAirBook\Structs\HiddenStops|null
     */
    public function getHiddenStops()
    {
        return $this->HiddenStops;
    }
    /**
     * Set HiddenStops value
     * @param \Sabre\EnhancedAirBook\Structs\HiddenStops $hiddenStops
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setHiddenStops(\Sabre\EnhancedAirBook\Structs\HiddenStops $hiddenStops = null)
    {
        $this->HiddenStops = $hiddenStops;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \Sabre\EnhancedAirBook\Structs\MarketingAirline|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \Sabre\EnhancedAirBook\Structs\MarketingAirline $marketingAirline
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setMarketingAirline(\Sabre\EnhancedAirBook\Structs\MarketingAirline $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return \Sabre\EnhancedAirBook\Structs\OperatingAirline[]|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\OperatingAirline[] $operatingAirline
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setOperatingAirline(array $operatingAirline = array())
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Add item to OperatingAirline value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\OperatingAirline $item
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function addToOperatingAirline(\Sabre\EnhancedAirBook\Structs\OperatingAirline $item)
    {
        $this->OperatingAirline[] = $item;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return int|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param int $flightNumber
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get ForceConnectionInd value
     * @return bool|null
     */
    public function getForceConnectionInd()
    {
        return $this->ForceConnectionInd;
    }
    /**
     * Set ForceConnectionInd value
     * @param bool $forceConnectionInd
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setForceConnectionInd($forceConnectionInd = null)
    {
        $this->ForceConnectionInd = $forceConnectionInd;
        return $this;
    }
    /**
     * Get ForceStopOverInd value
     * @return bool|null
     */
    public function getForceStopOverInd()
    {
        return $this->ForceStopOverInd;
    }
    /**
     * Set ForceStopOverInd value
     * @param bool $forceStopOverInd
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setForceStopOverInd($forceStopOverInd = null)
    {
        $this->ForceStopOverInd = $forceStopOverInd;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\EnhancedAirBook\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\EnhancedAirBook\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setDestinationLocation(\Sabre\EnhancedAirBook\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get MarriageGrp value
     * @return string|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @uses \Sabre\EnhancedAirBook\Enums\MarriageGrp::valueIsValid()
     * @uses \Sabre\EnhancedAirBook\Enums\MarriageGrp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $marriageGrp
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setMarriageGrp($marriageGrp = null)
    {
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\EnhancedAirBook\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\EnhancedAirBook\Structs\OriginLocation $originLocation
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setOriginLocation(\Sabre\EnhancedAirBook\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return string|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param string $numberInParty
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get InstantPurchase value
     * @return bool|null
     */
    public function getInstantPurchase()
    {
        return $this->InstantPurchase;
    }
    /**
     * Set InstantPurchase value
     * @param bool $instantPurchase
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setInstantPurchase($instantPurchase = null)
    {
        $this->InstantPurchase = $instantPurchase;
        return $this;
    }
    /**
     * Get eTicket value
     * @return bool|null
     */
    public function getETicket()
    {
        return $this->eTicket;
    }
    /**
     * Set eTicket value
     * @param bool $eTicket
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setETicket($eTicket = null)
    {
        $this->eTicket = $eTicket;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get BaggageAllowance value
     * @return \Sabre\EnhancedAirBook\Structs\BaggageAllowance|null
     */
    public function getBaggageAllowance()
    {
        return $this->BaggageAllowance;
    }
    /**
     * Set BaggageAllowance value
     * @param \Sabre\EnhancedAirBook\Structs\BaggageAllowance $baggageAllowance
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setBaggageAllowance(\Sabre\EnhancedAirBook\Structs\BaggageAllowance $baggageAllowance = null)
    {
        $this->BaggageAllowance = $baggageAllowance;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\EnhancedAirBook\Structs\FareBasis|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param \Sabre\EnhancedAirBook\Structs\FareBasis $fareBasis
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setFareBasis(\Sabre\EnhancedAirBook\Structs\FareBasis $fareBasis = null)
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get ValidityDates value
     * @return \Sabre\EnhancedAirBook\Structs\ValidityDates|null
     */
    public function getValidityDates()
    {
        return $this->ValidityDates;
    }
    /**
     * Set ValidityDates value
     * @param \Sabre\EnhancedAirBook\Structs\ValidityDates $validityDates
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setValidityDates(\Sabre\EnhancedAirBook\Structs\ValidityDates $validityDates = null)
    {
        $this->ValidityDates = $validityDates;
        return $this;
    }
    /**
     * Get ConnectionInd value
     * @return string|null
     */
    public function getConnectionInd()
    {
        return $this->ConnectionInd;
    }
    /**
     * Set ConnectionInd value
     * @param string $connectionInd
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setConnectionInd($connectionInd = null)
    {
        $this->ConnectionInd = $connectionInd;
        return $this;
    }
    /**
     * Get BSG_Record value
     * @return \Sabre\EnhancedAirBook\Structs\BSG_Record|null
     */
    public function getBSG_Record()
    {
        return $this->BSG_Record;
    }
    /**
     * Set BSG_Record value
     * @param \Sabre\EnhancedAirBook\Structs\BSG_Record $bSG_Record
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setBSG_Record(\Sabre\EnhancedAirBook\Structs\BSG_Record $bSG_Record = null)
    {
        $this->BSG_Record = $bSG_Record;
        return $this;
    }
    /**
     * Get CheckInAirline value
     * @return \Sabre\EnhancedAirBook\Structs\CheckInAirline|null
     */
    public function getCheckInAirline()
    {
        return $this->CheckInAirline;
    }
    /**
     * Set CheckInAirline value
     * @param \Sabre\EnhancedAirBook\Structs\CheckInAirline $checkInAirline
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setCheckInAirline(\Sabre\EnhancedAirBook\Structs\CheckInAirline $checkInAirline = null)
    {
        $this->CheckInAirline = $checkInAirline;
        return $this;
    }
    /**
     * Get CodeshareRecord value
     * @return \Sabre\EnhancedAirBook\Structs\CodeshareRecord|null
     */
    public function getCodeshareRecord()
    {
        return $this->CodeshareRecord;
    }
    /**
     * Set CodeshareRecord value
     * @param \Sabre\EnhancedAirBook\Structs\CodeshareRecord $codeshareRecord
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setCodeshareRecord(\Sabre\EnhancedAirBook\Structs\CodeshareRecord $codeshareRecord = null)
    {
        $this->CodeshareRecord = $codeshareRecord;
        return $this;
    }
    /**
     * Get MarketingCodeshareRecord value
     * @return \Sabre\EnhancedAirBook\Structs\MarketingCodeshareRecord|null
     */
    public function getMarketingCodeshareRecord()
    {
        return $this->MarketingCodeshareRecord;
    }
    /**
     * Set MarketingCodeshareRecord value
     * @param \Sabre\EnhancedAirBook\Structs\MarketingCodeshareRecord $marketingCodeshareRecord
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setMarketingCodeshareRecord(\Sabre\EnhancedAirBook\Structs\MarketingCodeshareRecord $marketingCodeshareRecord = null)
    {
        $this->MarketingCodeshareRecord = $marketingCodeshareRecord;
        return $this;
    }
    /**
     * Get Meal value
     * @return \Sabre\EnhancedAirBook\Structs\Meal[]|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * Set Meal value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Meal[] $meal
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setMeal(array $meal = array())
    {
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Add item to Meal value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Meal $item
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function addToMeal(\Sabre\EnhancedAirBook\Structs\Meal $item)
    {
        $this->Meal[] = $item;
        return $this;
    }
    /**
     * Get OperatingAirlinePricing value
     * @return \Sabre\EnhancedAirBook\Structs\OperatingAirlinePricing|null
     */
    public function getOperatingAirlinePricing()
    {
        return $this->OperatingAirlinePricing;
    }
    /**
     * Set OperatingAirlinePricing value
     * @param \Sabre\EnhancedAirBook\Structs\OperatingAirlinePricing $operatingAirlinePricing
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setOperatingAirlinePricing(\Sabre\EnhancedAirBook\Structs\OperatingAirlinePricing $operatingAirlinePricing = null)
    {
        $this->OperatingAirlinePricing = $operatingAirlinePricing;
        return $this;
    }
    /**
     * Get OperatingAirlineRecord value
     * @return \Sabre\EnhancedAirBook\Structs\OperatingAirlineRecord|null
     */
    public function getOperatingAirlineRecord()
    {
        return $this->OperatingAirlineRecord;
    }
    /**
     * Set OperatingAirlineRecord value
     * @param \Sabre\EnhancedAirBook\Structs\OperatingAirlineRecord $operatingAirlineRecord
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setOperatingAirlineRecord(\Sabre\EnhancedAirBook\Structs\OperatingAirlineRecord $operatingAirlineRecord = null)
    {
        $this->OperatingAirlineRecord = $operatingAirlineRecord;
        return $this;
    }
    /**
     * Get DisclosureCarrier value
     * @return \Sabre\EnhancedAirBook\Structs\DisclosureCarrier|null
     */
    public function getDisclosureCarrier()
    {
        return $this->DisclosureCarrier;
    }
    /**
     * Set DisclosureCarrier value
     * @param \Sabre\EnhancedAirBook\Structs\DisclosureCarrier $disclosureCarrier
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setDisclosureCarrier(\Sabre\EnhancedAirBook\Structs\DisclosureCarrier $disclosureCarrier = null)
    {
        $this->DisclosureCarrier = $disclosureCarrier;
        return $this;
    }
    /**
     * Get SupplierRef value
     * @return \Sabre\EnhancedAirBook\Structs\SupplierRef|null
     */
    public function getSupplierRef()
    {
        return $this->SupplierRef;
    }
    /**
     * Set SupplierRef value
     * @param \Sabre\EnhancedAirBook\Structs\SupplierRef $supplierRef
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setSupplierRef(\Sabre\EnhancedAirBook\Structs\SupplierRef $supplierRef = null)
    {
        $this->SupplierRef = $supplierRef;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get BSGIndicator value
     * @return string|null
     */
    public function getBSGIndicator()
    {
        return $this->BSGIndicator;
    }
    /**
     * Set BSGIndicator value
     * @param string $bSGIndicator
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setBSGIndicator($bSGIndicator = null)
    {
        $this->BSGIndicator = $bSGIndicator;
        return $this;
    }
    /**
     * Get UpdatedArrivalTime value
     * @return string|null
     */
    public function getUpdatedArrivalTime()
    {
        return $this->UpdatedArrivalTime;
    }
    /**
     * Set UpdatedArrivalTime value
     * @param string $updatedArrivalTime
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setUpdatedArrivalTime($updatedArrivalTime = null)
    {
        $this->UpdatedArrivalTime = $updatedArrivalTime;
        return $this;
    }
    /**
     * Get UpdatedDepartureTime value
     * @return string|null
     */
    public function getUpdatedDepartureTime()
    {
        return $this->UpdatedDepartureTime;
    }
    /**
     * Set UpdatedDepartureTime value
     * @param string $updatedDepartureTime
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setUpdatedDepartureTime($updatedDepartureTime = null)
    {
        $this->UpdatedDepartureTime = $updatedDepartureTime;
        return $this;
    }
    /**
     * Get AirMilesFlown value
     * @return string|null
     */
    public function getAirMilesFlown()
    {
        return $this->AirMilesFlown;
    }
    /**
     * Set AirMilesFlown value
     * @param string $airMilesFlown
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setAirMilesFlown($airMilesFlown = null)
    {
        $this->AirMilesFlown = $airMilesFlown;
        return $this;
    }
    /**
     * Get DayOfWeekInd value
     * @return string|null
     */
    public function getDayOfWeekInd()
    {
        return $this->DayOfWeekInd;
    }
    /**
     * Set DayOfWeekInd value
     * @param string $dayOfWeekInd
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setDayOfWeekInd($dayOfWeekInd = null)
    {
        $this->DayOfWeekInd = $dayOfWeekInd;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return string|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param string $elapsedTime
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setElapsedTime($elapsedTime = null)
    {
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get SpecialMeal value
     * @return bool|null
     */
    public function getSpecialMeal()
    {
        return $this->SpecialMeal;
    }
    /**
     * Set SpecialMeal value
     * @param bool $specialMeal
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setSpecialMeal($specialMeal = null)
    {
        $this->SpecialMeal = $specialMeal;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return string|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param string $stopQuantity
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setStopQuantity($stopQuantity = null)
    {
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Get CodeShare value
     * @return bool|null
     */
    public function getCodeShare()
    {
        return $this->CodeShare;
    }
    /**
     * Set CodeShare value
     * @param bool $codeShare
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setCodeShare($codeShare = null)
    {
        $this->CodeShare = $codeShare;
        return $this;
    }
    /**
     * Get Wetlease value
     * @return bool|null
     */
    public function getWetlease()
    {
        return $this->Wetlease;
    }
    /**
     * Set Wetlease value
     * @param bool $wetlease
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public function setWetlease($wetlease = null)
    {
        $this->Wetlease = $wetlease;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
