<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponent Structs
 * @subpackage Structs
 */
class FareComponent extends AbstractStructBase
{
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Location
     */
    public $Location;
    /**
     * The Dates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Dates
     */
    public $Dates;
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - documentation: "FareBasisCode" is used to return Fare Basis Code for particular Fare Component.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FareDirectionality
     * Meta informations extracted from the WSDL
     * - documentation: "FareDirectionality" is used to return directionality of the fare ("FROM" or "TO").
     * - use: optional
     * @var string
     */
    public $FareDirectionality;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return NUC amount for particular Fare Component.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The TicketDesignator
     * Meta informations extracted from the WSDL
     * - documentation: "TicketDesignator" is used to return Ticket Designator Code attached to Fare Basis Code.
     * - use: optional
     * @var string
     */
    public $TicketDesignator;
    /**
     * The GoverningCarrier
     * Meta informations extracted from the WSDL
     * - documentation: "GoverningCarrier" is used to return Governing Carrier Code e.g. EY, AA, LH.
     * - use: optional
     * @var string
     */
    public $GoverningCarrier;
    /**
     * Constructor method for FareComponent
     * @uses FareComponent::setLocation()
     * @uses FareComponent::setDates()
     * @uses FareComponent::setFareBasisCode()
     * @uses FareComponent::setFareDirectionality()
     * @uses FareComponent::setAmount()
     * @uses FareComponent::setTicketDesignator()
     * @uses FareComponent::setGoverningCarrier()
     * @param \Sabre\EnhancedAirBook\Structs\Location $location
     * @param \Sabre\EnhancedAirBook\Structs\Dates $dates
     * @param string $fareBasisCode
     * @param string $fareDirectionality
     * @param string $amount
     * @param string $ticketDesignator
     * @param string $governingCarrier
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Location $location = null, \Sabre\EnhancedAirBook\Structs\Dates $dates = null, $fareBasisCode = null, $fareDirectionality = null, $amount = null, $ticketDesignator = null, $governingCarrier = null)
    {
        $this
            ->setLocation($location)
            ->setDates($dates)
            ->setFareBasisCode($fareBasisCode)
            ->setFareDirectionality($fareDirectionality)
            ->setAmount($amount)
            ->setTicketDesignator($ticketDesignator)
            ->setGoverningCarrier($governingCarrier);
    }
    /**
     * Get Location value
     * @return \Sabre\EnhancedAirBook\Structs\Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Sabre\EnhancedAirBook\Structs\Location $location
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent
     */
    public function setLocation(\Sabre\EnhancedAirBook\Structs\Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Dates value
     * @return \Sabre\EnhancedAirBook\Structs\Dates|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @param \Sabre\EnhancedAirBook\Structs\Dates $dates
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent
     */
    public function setDates(\Sabre\EnhancedAirBook\Structs\Dates $dates = null)
    {
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FareDirectionality value
     * @return string|null
     */
    public function getFareDirectionality()
    {
        return $this->FareDirectionality;
    }
    /**
     * Set FareDirectionality value
     * @param string $fareDirectionality
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent
     */
    public function setFareDirectionality($fareDirectionality = null)
    {
        $this->FareDirectionality = $fareDirectionality;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TicketDesignator value
     * @return string|null
     */
    public function getTicketDesignator()
    {
        return $this->TicketDesignator;
    }
    /**
     * Set TicketDesignator value
     * @param string $ticketDesignator
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent
     */
    public function setTicketDesignator($ticketDesignator = null)
    {
        $this->TicketDesignator = $ticketDesignator;
        return $this;
    }
    /**
     * Get GoverningCarrier value
     * @return string|null
     */
    public function getGoverningCarrier()
    {
        return $this->GoverningCarrier;
    }
    /**
     * Set GoverningCarrier value
     * @param string $governingCarrier
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent
     */
    public function setGoverningCarrier($governingCarrier = null)
    {
        $this->GoverningCarrier = $governingCarrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\FareComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
