<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareBreakInfo Structs
 * @subpackage Structs
 */
class FareBreakInfo extends AbstractStructBase
{
    /**
     * The FareComponentNumber
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $FareComponentNumber;
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\BaseFare
     */
    public $BaseFare;
    /**
     * The EquivFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\EquivFare
     */
    public $EquivFare;
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 1
     * - pattern: [A-Z0-9]+(/[A-Z0-9]+)?
     * @var string
     */
    public $FareBasisCode;
    /**
     * The SideTripStartInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $SideTripStartInd;
    /**
     * The SideTripEndInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $SideTripEndInd;
    /**
     * The SideTripNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $SideTripNumber;
    /**
     * Constructor method for FareBreakInfo
     * @uses FareBreakInfo::setFareComponentNumber()
     * @uses FareBreakInfo::setBaseFare()
     * @uses FareBreakInfo::setEquivFare()
     * @uses FareBreakInfo::setFareBasisCode()
     * @uses FareBreakInfo::setSideTripStartInd()
     * @uses FareBreakInfo::setSideTripEndInd()
     * @uses FareBreakInfo::setSideTripNumber()
     * @param int $fareComponentNumber
     * @param \Sabre\EnhancedAirBook\Structs\BaseFare $baseFare
     * @param \Sabre\EnhancedAirBook\Structs\EquivFare $equivFare
     * @param string $fareBasisCode
     * @param bool $sideTripStartInd
     * @param bool $sideTripEndInd
     * @param int $sideTripNumber
     */
    public function __construct($fareComponentNumber = null, \Sabre\EnhancedAirBook\Structs\BaseFare $baseFare = null, \Sabre\EnhancedAirBook\Structs\EquivFare $equivFare = null, $fareBasisCode = null, $sideTripStartInd = null, $sideTripEndInd = null, $sideTripNumber = null)
    {
        $this
            ->setFareComponentNumber($fareComponentNumber)
            ->setBaseFare($baseFare)
            ->setEquivFare($equivFare)
            ->setFareBasisCode($fareBasisCode)
            ->setSideTripStartInd($sideTripStartInd)
            ->setSideTripEndInd($sideTripEndInd)
            ->setSideTripNumber($sideTripNumber);
    }
    /**
     * Get FareComponentNumber value
     * @return int
     */
    public function getFareComponentNumber()
    {
        return $this->FareComponentNumber;
    }
    /**
     * Set FareComponentNumber value
     * @param int $fareComponentNumber
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public function setFareComponentNumber($fareComponentNumber = null)
    {
        $this->FareComponentNumber = $fareComponentNumber;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return \Sabre\EnhancedAirBook\Structs\BaseFare|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \Sabre\EnhancedAirBook\Structs\BaseFare $baseFare
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public function setBaseFare(\Sabre\EnhancedAirBook\Structs\BaseFare $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \Sabre\EnhancedAirBook\Structs\EquivFare|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \Sabre\EnhancedAirBook\Structs\EquivFare $equivFare
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public function setEquivFare(\Sabre\EnhancedAirBook\Structs\EquivFare $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get SideTripStartInd value
     * @return bool|null
     */
    public function getSideTripStartInd()
    {
        return $this->SideTripStartInd;
    }
    /**
     * Set SideTripStartInd value
     * @param bool $sideTripStartInd
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public function setSideTripStartInd($sideTripStartInd = null)
    {
        $this->SideTripStartInd = $sideTripStartInd;
        return $this;
    }
    /**
     * Get SideTripEndInd value
     * @return bool|null
     */
    public function getSideTripEndInd()
    {
        return $this->SideTripEndInd;
    }
    /**
     * Set SideTripEndInd value
     * @param bool $sideTripEndInd
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public function setSideTripEndInd($sideTripEndInd = null)
    {
        $this->SideTripEndInd = $sideTripEndInd;
        return $this;
    }
    /**
     * Get SideTripNumber value
     * @return int|null
     */
    public function getSideTripNumber()
    {
        return $this->SideTripNumber;
    }
    /**
     * Set SideTripNumber value
     * @param int $sideTripNumber
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public function setSideTripNumber($sideTripNumber = null)
    {
        $this->SideTripNumber = $sideTripNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\FareBreakInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
