<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Documents Structs
 * @subpackage Structs
 */
class Documents extends AbstractStructBase
{
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\EnhancedAirBook\Structs\DocumentType[]
     */
    public $Document;
    /**
     * Constructor method for Documents
     * @uses Documents::setDocument()
     * @param \Sabre\EnhancedAirBook\Structs\DocumentType[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get Document value
     * @return \Sabre\EnhancedAirBook\Structs\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\DocumentType[] $document
     * @return \Sabre\EnhancedAirBook\Structs\Documents
     */
    public function setDocument(array $document = array())
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\DocumentType $item
     * @return \Sabre\EnhancedAirBook\Structs\Documents
     */
    public function addToDocument(\Sabre\EnhancedAirBook\Structs\DocumentType $item)
    {
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\Documents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
