<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryInfo Structs
 * @subpackage Structs
 */
class DeliveryInfo extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Address
     */
    public $Address;
    /**
     * The CollectionFee
     * Meta informations extracted from the WSDL
     * - documentation: "CollectionFee" is used to return the Collection fee details associated with the vehicle reservation if applicable.
     * - minOccurs: 0
     * @var string
     */
    public $CollectionFee;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous delivery-related text.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The SiteID
     * Meta informations extracted from the WSDL
     * - documentation: "SiteID" is used to return the collection site ID associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $SiteID;
    /**
     * The SiteName
     * Meta informations extracted from the WSDL
     * - documentation: "SiteName" is used to return the collection site name associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $SiteName;
    /**
     * Constructor method for DeliveryInfo
     * @uses DeliveryInfo::setAddress()
     * @uses DeliveryInfo::setCollectionFee()
     * @uses DeliveryInfo::setContactNumbers()
     * @uses DeliveryInfo::setText()
     * @uses DeliveryInfo::setSiteID()
     * @uses DeliveryInfo::setSiteName()
     * @param \Sabre\EnhancedAirBook\Structs\Address $address
     * @param string $collectionFee
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @param string $text
     * @param string $siteID
     * @param string $siteName
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Address $address = null, $collectionFee = null, \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null, $text = null, $siteID = null, $siteName = null)
    {
        $this
            ->setAddress($address)
            ->setCollectionFee($collectionFee)
            ->setContactNumbers($contactNumbers)
            ->setText($text)
            ->setSiteID($siteID)
            ->setSiteName($siteName);
    }
    /**
     * Get Address value
     * @return \Sabre\EnhancedAirBook\Structs\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\EnhancedAirBook\Structs\Address $address
     * @return \Sabre\EnhancedAirBook\Structs\DeliveryInfo
     */
    public function setAddress(\Sabre\EnhancedAirBook\Structs\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get CollectionFee value
     * @return string|null
     */
    public function getCollectionFee()
    {
        return $this->CollectionFee;
    }
    /**
     * Set CollectionFee value
     * @param string $collectionFee
     * @return \Sabre\EnhancedAirBook\Structs\DeliveryInfo
     */
    public function setCollectionFee($collectionFee = null)
    {
        $this->CollectionFee = $collectionFee;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\EnhancedAirBook\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\EnhancedAirBook\Structs\DeliveryInfo
     */
    public function setContactNumbers(\Sabre\EnhancedAirBook\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\EnhancedAirBook\Structs\DeliveryInfo
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get SiteID value
     * @return string|null
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param string $siteID
     * @return \Sabre\EnhancedAirBook\Structs\DeliveryInfo
     */
    public function setSiteID($siteID = null)
    {
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get SiteName value
     * @return string|null
     */
    public function getSiteName()
    {
        return $this->SiteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \Sabre\EnhancedAirBook\Structs\DeliveryInfo
     */
    public function setSiteName($siteName = null)
    {
        $this->SiteName = $siteName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\DeliveryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
