<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty Structs
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The TierLevel
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TierLevel;
    /**
     * The ProgramID
     * Meta informations extracted from the WSDL
     * - documentation: "ProgramID" is used to return the passenger's frequent flyer airline code.
     * - use: optional
     * @var string
     */
    public $ProgramID;
    /**
     * The TravelingCarrierCode
     * Meta informations extracted from the WSDL
     * - documentation: "TravelingCarrierCode" is used to return the traveling airline code.
     * - use: optional
     * @var string
     */
    public $TravelingCarrierCode;
    /**
     * The MembershipID
     * Meta informations extracted from the WSDL
     * - documentation: "MembershipID" is used to return the passenger's frequent flyer number. | "MembershipID" is used to return the frequent flyer number associated with the particular hotel reservation if applicable. | "MembershipID" is used to return
     * the frequent flyer number associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $MembershipID;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - documentation: "NameNumber" is used to associate the particular frequent flyer number to a particular passenger within the record.
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - documentation: "ShortText" is used to return miscellaneous frequent flyer-related information.
     * - use: optional
     * @var string
     */
    public $ShortText;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular flight segment within the record.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setTierLevel()
     * @uses CustLoyalty::setProgramID()
     * @uses CustLoyalty::setTravelingCarrierCode()
     * @uses CustLoyalty::setMembershipID()
     * @uses CustLoyalty::setNameNumber()
     * @uses CustLoyalty::setRPH()
     * @uses CustLoyalty::setShortText()
     * @uses CustLoyalty::setStatus()
     * @uses CustLoyalty::setId()
     * @param string $tierLevel
     * @param string $programID
     * @param string $travelingCarrierCode
     * @param string $membershipID
     * @param string $nameNumber
     * @param string $rPH
     * @param string $shortText
     * @param string $status
     * @param string $id
     */
    public function __construct($tierLevel = null, $programID = null, $travelingCarrierCode = null, $membershipID = null, $nameNumber = null, $rPH = null, $shortText = null, $status = null, $id = null)
    {
        $this
            ->setTierLevel($tierLevel)
            ->setProgramID($programID)
            ->setTravelingCarrierCode($travelingCarrierCode)
            ->setMembershipID($membershipID)
            ->setNameNumber($nameNumber)
            ->setRPH($rPH)
            ->setShortText($shortText)
            ->setStatus($status)
            ->setId($id);
    }
    /**
     * Get TierLevel value
     * @return string
     */
    public function getTierLevel()
    {
        return $this->TierLevel;
    }
    /**
     * Set TierLevel value
     * @param string $tierLevel
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setTierLevel($tierLevel = null)
    {
        $this->TierLevel = $tierLevel;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get TravelingCarrierCode value
     * @return string|null
     */
    public function getTravelingCarrierCode()
    {
        return $this->TravelingCarrierCode;
    }
    /**
     * Set TravelingCarrierCode value
     * @param string $travelingCarrierCode
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setTravelingCarrierCode($travelingCarrierCode = null)
    {
        $this->TravelingCarrierCode = $travelingCarrierCode;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
