<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageAllowance Structs
 * @subpackage Structs
 */
class BaggageAllowance extends AbstractStructBase
{
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Segment
     */
    public $Segment;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return the baggage allowance type associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for BaggageAllowance
     * @uses BaggageAllowance::setSegment()
     * @uses BaggageAllowance::setNumber()
     * @uses BaggageAllowance::setWeight()
     * @param \Sabre\EnhancedAirBook\Structs\Segment $segment
     * @param string $number
     * @param string $weight
     */
    public function __construct(\Sabre\EnhancedAirBook\Structs\Segment $segment = null, $number = null, $weight = null)
    {
        $this
            ->setSegment($segment)
            ->setNumber($number)
            ->setWeight($weight);
    }
    /**
     * Get Segment value
     * @return \Sabre\EnhancedAirBook\Structs\Segment|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \Sabre\EnhancedAirBook\Structs\Segment $segment
     * @return \Sabre\EnhancedAirBook\Structs\BaggageAllowance
     */
    public function setSegment(\Sabre\EnhancedAirBook\Structs\Segment $segment = null)
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\EnhancedAirBook\Structs\BaggageAllowance
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Sabre\EnhancedAirBook\Structs\BaggageAllowance
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\BaggageAllowance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
