<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BSG_Record Structs
 * @subpackage Structs
 */
class BSG_Record extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: "ID" is used to return the block space group record locator if applicable
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The BSGPNRCreatedDate
     * Meta informations extracted from the WSDL
     * - documentation: "BSGPNRCreatedDate" is used to return the date BSG PNR was created
     * - use: optional
     * @var string
     */
    public $BSGPNRCreatedDate;
    /**
     * Constructor method for BSG_Record
     * @uses BSG_Record::setID()
     * @uses BSG_Record::setBSGPNRCreatedDate()
     * @param string $iD
     * @param string $bSGPNRCreatedDate
     */
    public function __construct($iD = null, $bSGPNRCreatedDate = null)
    {
        $this
            ->setID($iD)
            ->setBSGPNRCreatedDate($bSGPNRCreatedDate);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Sabre\EnhancedAirBook\Structs\BSG_Record
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get BSGPNRCreatedDate value
     * @return string|null
     */
    public function getBSGPNRCreatedDate()
    {
        return $this->BSGPNRCreatedDate;
    }
    /**
     * Set BSGPNRCreatedDate value
     * @param string $bSGPNRCreatedDate
     * @return \Sabre\EnhancedAirBook\Structs\BSG_Record
     */
    public function setBSGPNRCreatedDate($bSGPNRCreatedDate = null)
    {
        $this->BSGPNRCreatedDate = $bSGPNRCreatedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\BSG_Record
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
