<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociationMatrices Structs
 * @subpackage Structs
 */
class AssociationMatrices extends AbstractStructBase
{
    /**
     * The AssociationMatrix
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Sabre\EnhancedAirBook\Structs\AssociationMatrix[]
     */
    public $AssociationMatrix;
    /**
     * Constructor method for AssociationMatrices
     * @uses AssociationMatrices::setAssociationMatrix()
     * @param \Sabre\EnhancedAirBook\Structs\AssociationMatrix[] $associationMatrix
     */
    public function __construct(array $associationMatrix = array())
    {
        $this
            ->setAssociationMatrix($associationMatrix);
    }
    /**
     * Get AssociationMatrix value
     * @return \Sabre\EnhancedAirBook\Structs\AssociationMatrix[]
     */
    public function getAssociationMatrix()
    {
        return $this->AssociationMatrix;
    }
    /**
     * Set AssociationMatrix value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\AssociationMatrix[] $associationMatrix
     * @return \Sabre\EnhancedAirBook\Structs\AssociationMatrices
     */
    public function setAssociationMatrix(array $associationMatrix = array())
    {
        $this->AssociationMatrix = $associationMatrix;
        return $this;
    }
    /**
     * Add item to AssociationMatrix value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\AssociationMatrix $item
     * @return \Sabre\EnhancedAirBook\Structs\AssociationMatrices
     */
    public function addToAssociationMatrix(\Sabre\EnhancedAirBook\Structs\AssociationMatrix $item)
    {
        $this->AssociationMatrix[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\AssociationMatrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
