<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApproximateTotalCharge Structs
 * Meta informations extracted from the WSDL
 * - documentation: ‘/AP-¤USD281.27’
 * @subpackage Structs
 */
class ApproximateTotalCharge extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: ‘/AP-¤USD281.27’
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The MileageAllowance
     * Meta informations extracted from the WSDL
     * - documentation: Unlimited or Free Miles allowed – ‘UNL’
     * - use: optional
     * @var string
     */
    public $MileageAllowance;
    /**
     * The NumDays
     * Meta informations extracted from the WSDL
     * - documentation: Number of days of rental – ‘3DY 0HR’
     * - use: optional
     * @var string
     */
    public $NumDays;
    /**
     * The NumHours
     * Meta informations extracted from the WSDL
     * - documentation: Number of hours of rental – ‘3DY 0HR’
     * - use: optional
     * @var string
     */
    public $NumHours;
    /**
     * The RateType
     * Meta informations extracted from the WSDL
     * - documentation: ???
     * - use: optional
     * @var string
     */
    public $RateType;
    /**
     * The TotalMandatoryCharges
     * Meta informations extracted from the WSDL
     * - documentation: Mandatory Charges – Taxes + Fees + etc… - ‘123.11MC’
     * - use: optional
     * @var string
     */
    public $TotalMandatoryCharges;
    /**
     * Constructor method for ApproximateTotalCharge
     * @uses ApproximateTotalCharge::setAmount()
     * @uses ApproximateTotalCharge::setMileageAllowance()
     * @uses ApproximateTotalCharge::setNumDays()
     * @uses ApproximateTotalCharge::setNumHours()
     * @uses ApproximateTotalCharge::setRateType()
     * @uses ApproximateTotalCharge::setTotalMandatoryCharges()
     * @param string $amount
     * @param string $mileageAllowance
     * @param string $numDays
     * @param string $numHours
     * @param string $rateType
     * @param string $totalMandatoryCharges
     */
    public function __construct($amount = null, $mileageAllowance = null, $numDays = null, $numHours = null, $rateType = null, $totalMandatoryCharges = null)
    {
        $this
            ->setAmount($amount)
            ->setMileageAllowance($mileageAllowance)
            ->setNumDays($numDays)
            ->setNumHours($numHours)
            ->setRateType($rateType)
            ->setTotalMandatoryCharges($totalMandatoryCharges);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get MileageAllowance value
     * @return string|null
     */
    public function getMileageAllowance()
    {
        return $this->MileageAllowance;
    }
    /**
     * Set MileageAllowance value
     * @param string $mileageAllowance
     * @return \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge
     */
    public function setMileageAllowance($mileageAllowance = null)
    {
        $this->MileageAllowance = $mileageAllowance;
        return $this;
    }
    /**
     * Get NumDays value
     * @return string|null
     */
    public function getNumDays()
    {
        return $this->NumDays;
    }
    /**
     * Set NumDays value
     * @param string $numDays
     * @return \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge
     */
    public function setNumDays($numDays = null)
    {
        $this->NumDays = $numDays;
        return $this;
    }
    /**
     * Get NumHours value
     * @return string|null
     */
    public function getNumHours()
    {
        return $this->NumHours;
    }
    /**
     * Set NumHours value
     * @param string $numHours
     * @return \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge
     */
    public function setNumHours($numHours = null)
    {
        $this->NumHours = $numHours;
        return $this;
    }
    /**
     * Get RateType value
     * @return string|null
     */
    public function getRateType()
    {
        return $this->RateType;
    }
    /**
     * Set RateType value
     * @param string $rateType
     * @return \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge
     */
    public function setRateType($rateType = null)
    {
        $this->RateType = $rateType;
        return $this;
    }
    /**
     * Get TotalMandatoryCharges value
     * @return string|null
     */
    public function getTotalMandatoryCharges()
    {
        return $this->TotalMandatoryCharges;
    }
    /**
     * Set TotalMandatoryCharges value
     * @param string $totalMandatoryCharges
     * @return \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge
     */
    public function setTotalMandatoryCharges($totalMandatoryCharges = null)
    {
        $this->TotalMandatoryCharges = $totalMandatoryCharges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\ApproximateTotalCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
