<?php

namespace Sabre\EnhancedAirBook\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirExtras Structs
 * @subpackage Structs
 */
class AirExtras extends AbstractStructBase
{
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Ind;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Qualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Qualifier;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EnhancedAirBook\Structs\Ticketing[]
     */
    public $Ticketing;
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Summary;
    /**
     * Constructor method for AirExtras
     * @uses AirExtras::setInd()
     * @uses AirExtras::setCustLoyalty()
     * @uses AirExtras::setQualifier()
     * @uses AirExtras::setTicketing()
     * @uses AirExtras::setSummary()
     * @param bool $ind
     * @param \Sabre\EnhancedAirBook\Structs\CustLoyalty[] $custLoyalty
     * @param string[] $qualifier
     * @param \Sabre\EnhancedAirBook\Structs\Ticketing[] $ticketing
     * @param bool $summary
     */
    public function __construct($ind = null, array $custLoyalty = array(), array $qualifier = array(), array $ticketing = array(), $summary = null)
    {
        $this
            ->setInd($ind)
            ->setCustLoyalty($custLoyalty)
            ->setQualifier($qualifier)
            ->setTicketing($ticketing)
            ->setSummary($summary);
    }
    /**
     * Get Ind value
     * @return bool
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \Sabre\EnhancedAirBook\Structs\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CustLoyalty[] $custLoyalty
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\CustLoyalty $item
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public function addToCustLoyalty(\Sabre\EnhancedAirBook\Structs\CustLoyalty $item)
    {
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Qualifier value
     * @return string[]|null
     */
    public function getQualifier()
    {
        return $this->Qualifier;
    }
    /**
     * Set Qualifier value
     * @throws \InvalidArgumentException
     * @param string[] $qualifier
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public function setQualifier(array $qualifier = array())
    {
        $this->Qualifier = $qualifier;
        return $this;
    }
    /**
     * Add item to Qualifier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public function addToQualifier($item)
    {
        $this->Qualifier[] = $item;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \Sabre\EnhancedAirBook\Structs\Ticketing[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Ticketing[] $ticketing
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public function setTicketing(array $ticketing = array())
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\EnhancedAirBook\Structs\Ticketing $item
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public function addToTicketing(\Sabre\EnhancedAirBook\Structs\Ticketing $item)
    {
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Get Summary value
     * @return bool|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param bool $summary
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public function setSummary($summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EnhancedAirBook\Structs\AirExtras
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
