<?php

namespace Sabre\EnhancedAirBook\Enums;

/**
 * This class stands for MarriageGrp Enums
 * @subpackage Enumerations
 */
class MarriageGrp
{
    /**
     * Constant for value 'O'
     * @return string 'O'
     */
    const VALUE_O = 'O';
    /**
     * Constant for value 'I'
     * @return string 'I'
     */
    const VALUE_I = 'I';
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - documentation: "Ind" is used to indicate that the particular flight segment is part of a married connection.
     * - use: optional
     * @var string
     */
    public $Ind;
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - documentation: "Group" is used to return the marraige group number if applicable.
     * - use: optional
     * @var string
     */
    public $Group;
    /**
     * The Sequence
     * Meta informations extracted from the WSDL
     * - documentation: "Sequence" is used to return the marraige sequence number if applicable.
     * - use: optional
     * @var string
     */
    public $Sequence;
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_O
     * @uses self::VALUE_I
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_O,
            self::VALUE_I,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
