<?php

namespace Sabre\EnhancedAirBook;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Message.Condition' => '\\Sabre\\EnhancedAirBook\\Structs\\Message_Condition',
            'STL_Payload' => '\\Sabre\\EnhancedAirBook\\Structs\\STL_Payload',
            'STL_Request_Payload' => '\\Sabre\\EnhancedAirBook\\Structs\\STL_Request_Payload',
            'STL_Response_Payload' => '\\Sabre\\EnhancedAirBook\\Structs\\STL_Response_Payload',
            'STL_Notif_Payload' => '\\Sabre\\EnhancedAirBook\\Structs\\STL_Notif_Payload',
            'Results' => '\\Sabre\\EnhancedAirBook\\Structs\\Results',
            'ApplicationResults' => '\\Sabre\\EnhancedAirBook\\Structs\\ApplicationResults',
            'ProblemInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\ProblemInformation',
            'SystemSpecificResults' => '\\Sabre\\EnhancedAirBook\\Structs\\SystemSpecificResults',
            'HostCommand' => '\\Sabre\\EnhancedAirBook\\Structs\\HostCommand',
            'EnhancedAirBookRQ' => '\\Sabre\\EnhancedAirBook\\Structs\\EnhancedAirBookRQ',
            'AirTaxRQ' => '\\Sabre\\EnhancedAirBook\\Structs\\AirTaxRQ',
            'ItineraryInfos' => '\\Sabre\\EnhancedAirBook\\Structs\\ItineraryInfos',
            'ItineraryInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\ItineraryInfo',
            'ReservationItems' => '\\Sabre\\EnhancedAirBook\\Structs\\ReservationItems',
            'Item' => '\\Sabre\\EnhancedAirBook\\Structs\\Item',
            'AirFareInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\AirFareInfo',
            'PTC_FareBreakdown' => '\\Sabre\\EnhancedAirBook\\Structs\\PTC_FareBreakdown',
            'PassengerFare' => '\\Sabre\\EnhancedAirBook\\Structs\\PassengerFare',
            'BaseFare' => '\\Sabre\\EnhancedAirBook\\Structs\\BaseFare',
            'EquivFare' => '\\Sabre\\EnhancedAirBook\\Structs\\EquivFare',
            'PassengerType' => '\\Sabre\\EnhancedAirBook\\Structs\\PassengerType',
            'FlightSegment' => '\\Sabre\\EnhancedAirBook\\Structs\\FlightSegment',
            'ArrivalAirport' => '\\Sabre\\EnhancedAirBook\\Structs\\ArrivalAirport',
            'DepartureAirport' => '\\Sabre\\EnhancedAirBook\\Structs\\DepartureAirport',
            'Equipment' => '\\Sabre\\EnhancedAirBook\\Structs\\Equipment',
            'FareBreakInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\FareBreakInfo',
            'HiddenStops' => '\\Sabre\\EnhancedAirBook\\Structs\\HiddenStops',
            'HiddenStop' => '\\Sabre\\EnhancedAirBook\\Structs\\HiddenStop',
            'MarketingAirline' => '\\Sabre\\EnhancedAirBook\\Structs\\MarketingAirline',
            'OperatingAirline' => '\\Sabre\\EnhancedAirBook\\Structs\\OperatingAirline',
            'POS' => '\\Sabre\\EnhancedAirBook\\Structs\\POS',
            'Source' => '\\Sabre\\EnhancedAirBook\\Structs\\Source',
            'TPA_Extensions' => '\\Sabre\\EnhancedAirBook\\Structs\\TPA_Extensions',
            'UserInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\UserInfo',
            'AAACity' => '\\Sabre\\EnhancedAirBook\\Structs\\AAACity',
            'Action' => '\\Sabre\\EnhancedAirBook\\Structs\\Action',
            'AgentSine' => '\\Sabre\\EnhancedAirBook\\Structs\\AgentSine',
            'Branch' => '\\Sabre\\EnhancedAirBook\\Structs\\Branch',
            'Partition' => '\\Sabre\\EnhancedAirBook\\Structs\\Partition',
            'Service' => '\\Sabre\\EnhancedAirBook\\Structs\\Service',
            'Station' => '\\Sabre\\EnhancedAirBook\\Structs\\Station',
            'Transaction' => '\\Sabre\\EnhancedAirBook\\Structs\\Transaction',
            'OTA_AirBookRQ' => '\\Sabre\\EnhancedAirBook\\Structs\\OTA_AirBookRQ',
            'RetryRebook' => '\\Sabre\\EnhancedAirBook\\Structs\\RetryRebook',
            'HaltOnStatus' => '\\Sabre\\EnhancedAirBook\\Structs\\HaltOnStatus',
            'OriginDestinationInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\OriginDestinationInformation',
            'DestinationLocation' => '\\Sabre\\EnhancedAirBook\\Structs\\DestinationLocation',
            'OriginLocation' => '\\Sabre\\EnhancedAirBook\\Structs\\OriginLocation',
            'RedisplayReservation' => '\\Sabre\\EnhancedAirBook\\Structs\\RedisplayReservation',
            'OTA_AirPriceRQ' => '\\Sabre\\EnhancedAirBook\\Structs\\OTA_AirPriceRQ',
            'PriceComparison' => '\\Sabre\\EnhancedAirBook\\Structs\\PriceComparison',
            'AcceptablePriceIncrease' => '\\Sabre\\EnhancedAirBook\\Structs\\AcceptablePriceIncrease',
            'PriceRequestInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\PriceRequestInformation',
            'OptionalQualifiers' => '\\Sabre\\EnhancedAirBook\\Structs\\OptionalQualifiers',
            'FlightQualifiers' => '\\Sabre\\EnhancedAirBook\\Structs\\FlightQualifiers',
            'VendorPrefs' => '\\Sabre\\EnhancedAirBook\\Structs\\VendorPrefs',
            'Airline' => '\\Sabre\\EnhancedAirBook\\Structs\\Airline',
            'FOP_Qualifiers' => '\\Sabre\\EnhancedAirBook\\Structs\\FOP_Qualifiers',
            'BasicFOP' => '\\Sabre\\EnhancedAirBook\\Structs\\BasicFOP',
            'CC_Info' => '\\Sabre\\EnhancedAirBook\\Structs\\CC_Info',
            'PaymentCard' => '\\Sabre\\EnhancedAirBook\\Structs\\PaymentCard',
            'BSP_Ticketing' => '\\Sabre\\EnhancedAirBook\\Structs\\BSP_Ticketing',
            'MultipleFOP' => '\\Sabre\\EnhancedAirBook\\Structs\\MultipleFOP',
            'Fare' => '\\Sabre\\EnhancedAirBook\\Structs\\Fare',
            'FOP_One' => '\\Sabre\\EnhancedAirBook\\Structs\\FOP_One',
            'FOP_Two' => '\\Sabre\\EnhancedAirBook\\Structs\\FOP_Two',
            'MultipleMiscFOP' => '\\Sabre\\EnhancedAirBook\\Structs\\MultipleMiscFOP',
            'ExtendedPayment' => '\\Sabre\\EnhancedAirBook\\Structs\\ExtendedPayment',
            'Taxes' => '\\Sabre\\EnhancedAirBook\\Structs\\Taxes',
            'Tax' => '\\Sabre\\EnhancedAirBook\\Structs\\Tax',
            'PayLaterPlan' => '\\Sabre\\EnhancedAirBook\\Structs\\PayLaterPlan',
            'FOP' => '\\Sabre\\EnhancedAirBook\\Structs\\FOP',
            'Installment' => '\\Sabre\\EnhancedAirBook\\Structs\\Installment',
            'MultipleCC_FOP' => '\\Sabre\\EnhancedAirBook\\Structs\\MultipleCC_FOP',
            'CC_One' => '\\Sabre\\EnhancedAirBook\\Structs\\CC_One',
            'CC_Two' => '\\Sabre\\EnhancedAirBook\\Structs\\CC_Two',
            'SabreSonicTicketing' => '\\Sabre\\EnhancedAirBook\\Structs\\SabreSonicTicketing',
            'EnhancedMultipleFOP' => '\\Sabre\\EnhancedAirBook\\Structs\\EnhancedMultipleFOP',
            'MiscQualifiers' => '\\Sabre\\EnhancedAirBook\\Structs\\MiscQualifiers',
            'AirExtras' => '\\Sabre\\EnhancedAirBook\\Structs\\AirExtras',
            'CustLoyalty' => '\\Sabre\\EnhancedAirBook\\Structs\\CustLoyalty',
            'Ticketing' => '\\Sabre\\EnhancedAirBook\\Structs\\Ticketing',
            'BaggageAllowance' => '\\Sabre\\EnhancedAirBook\\Structs\\BaggageAllowance',
            'Segment' => '\\Sabre\\EnhancedAirBook\\Structs\\Segment',
            'Commission' => '\\Sabre\\EnhancedAirBook\\Structs\\Commission',
            'Customer' => '\\Sabre\\EnhancedAirBook\\Structs\\Customer',
            'Endorsements' => '\\Sabre\\EnhancedAirBook\\Structs\\Endorsements',
            'MultiTicket' => '\\Sabre\\EnhancedAirBook\\Structs\\MultiTicket',
            'TourCode' => '\\Sabre\\EnhancedAirBook\\Structs\\TourCode',
            'SuppressFareReplaceWithBT' => '\\Sabre\\EnhancedAirBook\\Structs\\SuppressFareReplaceWithBT',
            'SuppressFareReplaceWithIT' => '\\Sabre\\EnhancedAirBook\\Structs\\SuppressFareReplaceWithIT',
            'SuppressIT' => '\\Sabre\\EnhancedAirBook\\Structs\\SuppressIT',
            'SuppressITSupressFare' => '\\Sabre\\EnhancedAirBook\\Structs\\SuppressITSupressFare',
            'PricingQualifiers' => '\\Sabre\\EnhancedAirBook\\Structs\\PricingQualifiers',
            'Account' => '\\Sabre\\EnhancedAirBook\\Structs\\Account',
            'AlternativePricing' => '\\Sabre\\EnhancedAirBook\\Structs\\AlternativePricing',
            'Overrides' => '\\Sabre\\EnhancedAirBook\\Structs\\Overrides',
            'MatchNoMatch' => '\\Sabre\\EnhancedAirBook\\Structs\\MatchNoMatch',
            'NoMatch' => '\\Sabre\\EnhancedAirBook\\Structs\\NoMatch',
            'BargainFinder' => '\\Sabre\\EnhancedAirBook\\Structs\\BargainFinder',
            'Brand' => '\\Sabre\\EnhancedAirBook\\Structs\\Brand',
            'CommandPricing' => '\\Sabre\\EnhancedAirBook\\Structs\\CommandPricing',
            'Discount' => '\\Sabre\\EnhancedAirBook\\Structs\\Discount',
            'FareBasis' => '\\Sabre\\EnhancedAirBook\\Structs\\FareBasis',
            'Corporate' => '\\Sabre\\EnhancedAirBook\\Structs\\Corporate',
            'FareOptions' => '\\Sabre\\EnhancedAirBook\\Structs\\FareOptions',
            'ItineraryOptions' => '\\Sabre\\EnhancedAirBook\\Structs\\ItineraryOptions',
            'BreakFare' => '\\Sabre\\EnhancedAirBook\\Structs\\BreakFare',
            'ForceConnection' => '\\Sabre\\EnhancedAirBook\\Structs\\ForceConnection',
            'ForceStopOver' => '\\Sabre\\EnhancedAirBook\\Structs\\ForceStopOver',
            'OverrideBreak' => '\\Sabre\\EnhancedAirBook\\Structs\\OverrideBreak',
            'SegmentSelect' => '\\Sabre\\EnhancedAirBook\\Structs\\SegmentSelect',
            'SideTrip' => '\\Sabre\\EnhancedAirBook\\Structs\\SideTrip',
            'NameSelect' => '\\Sabre\\EnhancedAirBook\\Structs\\NameSelect',
            'NetRemit' => '\\Sabre\\EnhancedAirBook\\Structs\\NetRemit',
            'CAR' => '\\Sabre\\EnhancedAirBook\\Structs\\CAR',
            'Cash' => '\\Sabre\\EnhancedAirBook\\Structs\\Cash',
            'Credit' => '\\Sabre\\EnhancedAirBook\\Structs\\Credit',
            'FuelSurchargeOverride' => '\\Sabre\\EnhancedAirBook\\Structs\\FuelSurchargeOverride',
            'GoverningCarrierOverride' => '\\Sabre\\EnhancedAirBook\\Structs\\GoverningCarrierOverride',
            'NoAdvancePurchase' => '\\Sabre\\EnhancedAirBook\\Structs\\NoAdvancePurchase',
            'NoFareRestrictions' => '\\Sabre\\EnhancedAirBook\\Structs\\NoFareRestrictions',
            'NoMinMaxStay' => '\\Sabre\\EnhancedAirBook\\Structs\\NoMinMaxStay',
            'NoPenalty' => '\\Sabre\\EnhancedAirBook\\Structs\\NoPenalty',
            'Purchase' => '\\Sabre\\EnhancedAirBook\\Structs\\Purchase',
            'PlusUp' => '\\Sabre\\EnhancedAirBook\\Structs\\PlusUp',
            'SpecificFare' => '\\Sabre\\EnhancedAirBook\\Structs\\SpecificFare',
            'SpecificPenalty' => '\\Sabre\\EnhancedAirBook\\Structs\\SpecificPenalty',
            'Changeable' => '\\Sabre\\EnhancedAirBook\\Structs\\Changeable',
            'EitherOr' => '\\Sabre\\EnhancedAirBook\\Structs\\EitherOr',
            'Refundable' => '\\Sabre\\EnhancedAirBook\\Structs\\Refundable',
            'NoTax' => '\\Sabre\\EnhancedAirBook\\Structs\\NoTax',
            'TaxExempt' => '\\Sabre\\EnhancedAirBook\\Structs\\TaxExempt',
            'TaxOverride' => '\\Sabre\\EnhancedAirBook\\Structs\\TaxOverride',
            'ValidityDates' => '\\Sabre\\EnhancedAirBook\\Structs\\ValidityDates',
            'PostProcessing' => '\\Sabre\\EnhancedAirBook\\Structs\\PostProcessing',
            'PreProcessing' => '\\Sabre\\EnhancedAirBook\\Structs\\PreProcessing',
            'UniqueID' => '\\Sabre\\EnhancedAirBook\\Structs\\UniqueID',
            'EnhancedAirBookRS' => '\\Sabre\\EnhancedAirBook\\Structs\\EnhancedAirBookRS',
            'AirTaxRS' => '\\Sabre\\EnhancedAirBook\\Structs\\AirTaxRS',
            'TaxInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\TaxInfo',
            'OTA_AirBookRS' => '\\Sabre\\EnhancedAirBook\\Structs\\OTA_AirBookRS',
            'OriginDestinationOption' => '\\Sabre\\EnhancedAirBook\\Structs\\OriginDestinationOption',
            'OTA_AirPriceRS' => '\\Sabre\\EnhancedAirBook\\Structs\\OTA_AirPriceRS',
            'PriceQuote' => '\\Sabre\\EnhancedAirBook\\Structs\\PriceQuote',
            'MiscInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\MiscInformation',
            'BaggageInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\BaggageInfo',
            'SubCodeProperties' => '\\Sabre\\EnhancedAirBook\\Structs\\SubCodeProperties',
            'AncillaryService' => '\\Sabre\\EnhancedAirBook\\Structs\\AncillaryService',
            'DescriptionOne' => '\\Sabre\\EnhancedAirBook\\Structs\\DescriptionOne',
            'DescriptionTwo' => '\\Sabre\\EnhancedAirBook\\Structs\\DescriptionTwo',
            'SizeWeightInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\SizeWeightInfo',
            'MaximumSizeInAlternate' => '\\Sabre\\EnhancedAirBook\\Structs\\MaximumSizeInAlternate',
            'MaximumSize' => '\\Sabre\\EnhancedAirBook\\Structs\\MaximumSize',
            'MaximumWeightInAlternate' => '\\Sabre\\EnhancedAirBook\\Structs\\MaximumWeightInAlternate',
            'MaximumWeight' => '\\Sabre\\EnhancedAirBook\\Structs\\MaximumWeight',
            'MinimumSizeInAlternate' => '\\Sabre\\EnhancedAirBook\\Structs\\MinimumSizeInAlternate',
            'MinimumSize' => '\\Sabre\\EnhancedAirBook\\Structs\\MinimumSize',
            'MinimumWeightInAlternate' => '\\Sabre\\EnhancedAirBook\\Structs\\MinimumWeightInAlternate',
            'MinimumWeight' => '\\Sabre\\EnhancedAirBook\\Structs\\MinimumWeight',
            'HeaderInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\HeaderInformation',
            'AlternateBooking' => '\\Sabre\\EnhancedAirBook\\Structs\\AlternateBooking',
            'DivideParty' => '\\Sabre\\EnhancedAirBook\\Structs\\DivideParty',
            'ValidatingCarrier' => '\\Sabre\\EnhancedAirBook\\Structs\\ValidatingCarrier',
            'SolutionInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\SolutionInformation',
            'OptionalCharges' => '\\Sabre\\EnhancedAirBook\\Structs\\OptionalCharges',
            'ChargeDetails' => '\\Sabre\\EnhancedAirBook\\Structs\\ChargeDetails',
            'ChargeBreakdown' => '\\Sabre\\EnhancedAirBook\\Structs\\ChargeBreakdown',
            'Base' => '\\Sabre\\EnhancedAirBook\\Structs\\Base',
            'Equiv' => '\\Sabre\\EnhancedAirBook\\Structs\\Equiv',
            'PassengerTypeQuantity' => '\\Sabre\\EnhancedAirBook\\Structs\\PassengerTypeQuantity',
            'Total' => '\\Sabre\\EnhancedAirBook\\Structs\\Total',
            'ReasonForIssuance' => '\\Sabre\\EnhancedAirBook\\Structs\\ReasonForIssuance',
            'SSIM' => '\\Sabre\\EnhancedAirBook\\Structs\\SSIM',
            'SSR' => '\\Sabre\\EnhancedAirBook\\Structs\\SSR',
            'Ticket' => '\\Sabre\\EnhancedAirBook\\Structs\\Ticket',
            'TicketingInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\TicketingInfo',
            'Coupon' => '\\Sabre\\EnhancedAirBook\\Structs\\Coupon',
            'PersonName' => '\\Sabre\\EnhancedAirBook\\Structs\\PersonName',
            'GivenName' => '\\Sabre\\EnhancedAirBook\\Structs\\GivenName',
            'Surname' => '\\Sabre\\EnhancedAirBook\\Structs\\Surname',
            'PricedItinerary' => '\\Sabre\\EnhancedAirBook\\Structs\\PricedItinerary',
            'AirItineraryPricingInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\AirItineraryPricingInfo',
            'AncillaryFees' => '\\Sabre\\EnhancedAirBook\\Structs\\AncillaryFees',
            'FeeInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\FeeInformation',
            'BaggageProvisions' => '\\Sabre\\EnhancedAirBook\\Structs\\BaggageProvisions',
            'Associations' => '\\Sabre\\EnhancedAirBook\\Structs\\Associations',
            'CarrierCode' => '\\Sabre\\EnhancedAirBook\\Structs\\CarrierCode',
            'DepartureDate' => '\\Sabre\\EnhancedAirBook\\Structs\\DepartureDate',
            'FlightNumber' => '\\Sabre\\EnhancedAirBook\\Structs\\FlightNumber',
            'PNR_Segment' => '\\Sabre\\EnhancedAirBook\\Structs\\PNR_Segment',
            'ResBookDesigCode' => '\\Sabre\\EnhancedAirBook\\Structs\\ResBookDesigCode',
            'StatusCode' => '\\Sabre\\EnhancedAirBook\\Structs\\StatusCode',
            'PriceInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\PriceInformation',
            'SubCodeInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\SubCodeInfo',
            'SubCodeForAllowance' => '\\Sabre\\EnhancedAirBook\\Structs\\SubCodeForAllowance',
            'WeightLimit' => '\\Sabre\\EnhancedAirBook\\Structs\\WeightLimit',
            'FareCalculation' => '\\Sabre\\EnhancedAirBook\\Structs\\FareCalculation',
            'FareCalculationBreakdown' => '\\Sabre\\EnhancedAirBook\\Structs\\FareCalculationBreakdown',
            'Departure' => '\\Sabre\\EnhancedAirBook\\Structs\\Departure',
            'Mileage' => '\\Sabre\\EnhancedAirBook\\Structs\\Mileage',
            'Surcharges' => '\\Sabre\\EnhancedAirBook\\Structs\\Surcharges',
            'StopoverCharge' => '\\Sabre\\EnhancedAirBook\\Structs\\StopoverCharge',
            'ItinTotalFare' => '\\Sabre\\EnhancedAirBook\\Structs\\ItinTotalFare',
            'NonUS_DOT_Disclosure' => '\\Sabre\\EnhancedAirBook\\Structs\\NonUS_DOT_Disclosure',
            'US_DOT_Disclosure' => '\\Sabre\\EnhancedAirBook\\Structs\\US_DOT_Disclosure',
            'PrivateFare' => '\\Sabre\\EnhancedAirBook\\Structs\\PrivateFare',
            'TotalFare' => '\\Sabre\\EnhancedAirBook\\Structs\\TotalFare',
            'Warnings' => '\\Sabre\\EnhancedAirBook\\Structs\\Warnings',
            'Warning' => '\\Sabre\\EnhancedAirBook\\Structs\\Warning',
            'BrandedFareInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\BrandedFareInformation',
            'PenaltyInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\PenaltyInformation',
            'TicketingFees' => '\\Sabre\\EnhancedAirBook\\Structs\\TicketingFees',
            'TravelItineraryReadRS' => '\\Sabre\\EnhancedAirBook\\Structs\\TravelItineraryReadRS',
            'TravelItinerary' => '\\Sabre\\EnhancedAirBook\\Structs\\TravelItinerary',
            'AccountingInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\AccountingInfo',
            'AccountVendor' => '\\Sabre\\EnhancedAirBook\\Structs\\AccountVendor',
            'DocumentInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\DocumentInfo',
            'Document' => '\\Sabre\\EnhancedAirBook\\Structs\\Document',
            'PaymentInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\PaymentInfo',
            'Payment' => '\\Sabre\\EnhancedAirBook\\Structs\\Payment',
            'GST' => '\\Sabre\\EnhancedAirBook\\Structs\\GST',
            'QST' => '\\Sabre\\EnhancedAirBook\\Structs\\QST',
            'eTicket' => '\\Sabre\\EnhancedAirBook\\Structs\\ETicket',
            'Exchange' => '\\Sabre\\EnhancedAirBook\\Structs\\Exchange',
            'CustomerInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\CustomerInfo',
            'Address' => '\\Sabre\\EnhancedAirBook\\Structs\\Address',
            'AddressLine' => '\\Sabre\\EnhancedAirBook\\Structs\\AddressLine',
            'ContactNumbers' => '\\Sabre\\EnhancedAirBook\\Structs\\ContactNumbers',
            'ContactNumber' => '\\Sabre\\EnhancedAirBook\\Structs\\ContactNumber',
            'Passport' => '\\Sabre\\EnhancedAirBook\\Structs\\Passport',
            'CardHolderInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\CardHolderInfo',
            'Form' => '\\Sabre\\EnhancedAirBook\\Structs\\Form',
            'Email' => '\\Sabre\\EnhancedAirBook\\Structs\\Email',
            'GroupInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\GroupInfo',
            'AssociatedReferenceInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\AssociatedReferenceInformation',
            'AssociatedPNRSummaries' => '\\Sabre\\EnhancedAirBook\\Structs\\AssociatedPNRSummaries',
            'AssociatedPNRSummary' => '\\Sabre\\EnhancedAirBook\\Structs\\AssociatedPNRSummary',
            'ProfileIndex' => '\\Sabre\\EnhancedAirBook\\Structs\\ProfileIndex',
            'FileInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\FileInfo',
            'File' => '\\Sabre\\EnhancedAirBook\\Structs\\File',
            'ItineraryPricing' => '\\Sabre\\EnhancedAirBook\\Structs\\ItineraryPricing',
            'FuturePriceInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\FuturePriceInfo',
            'BaggageFees' => '\\Sabre\\EnhancedAirBook\\Structs\\BaggageFees',
            'GlobalNetRemit' => '\\Sabre\\EnhancedAirBook\\Structs\\GlobalNetRemit',
            'NetFare' => '\\Sabre\\EnhancedAirBook\\Structs\\NetFare',
            'SellingFare' => '\\Sabre\\EnhancedAirBook\\Structs\\SellingFare',
            'SignatureLine' => '\\Sabre\\EnhancedAirBook\\Structs\\SignatureLine',
            'AssociatedData' => '\\Sabre\\EnhancedAirBook\\Structs\\AssociatedData',
            'AssociatedDataItem' => '\\Sabre\\EnhancedAirBook\\Structs\\AssociatedDataItem',
            'TaxBreakdownCode' => '\\Sabre\\EnhancedAirBook\\Structs\\TaxBreakdownCode',
            'Totals' => '\\Sabre\\EnhancedAirBook\\Structs\\Totals',
            'PrivateFareInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\PrivateFareInformation',
            'NetRemits' => '\\Sabre\\EnhancedAirBook\\Structs\\NetRemits',
            'Endorsement' => '\\Sabre\\EnhancedAirBook\\Structs\\Endorsement',
            'FareComponent' => '\\Sabre\\EnhancedAirBook\\Structs\\FareComponent',
            'Location' => '\\Sabre\\EnhancedAirBook\\Structs\\Location',
            'Dates' => '\\Sabre\\EnhancedAirBook\\Structs\\Dates',
            'NetTicketingInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\NetTicketingInfo',
            'NetFareDetails' => '\\Sabre\\EnhancedAirBook\\Structs\\NetFareDetails',
            'TotalTax' => '\\Sabre\\EnhancedAirBook\\Structs\\TotalTax',
            'Percent' => '\\Sabre\\EnhancedAirBook\\Structs\\Percent',
            'SellingFareDetails' => '\\Sabre\\EnhancedAirBook\\Structs\\SellingFareDetails',
            'ResponseHeader' => '\\Sabre\\EnhancedAirBook\\Structs\\ResponseHeader',
            'PriceQuotePlus' => '\\Sabre\\EnhancedAirBook\\Structs\\PriceQuotePlus',
            'PassengerInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\PassengerInfo',
            'PassengerData' => '\\Sabre\\EnhancedAirBook\\Structs\\PassengerData',
            'TicketingInstructionsInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\TicketingInstructionsInfo',
            'TicketingInstruction' => '\\Sabre\\EnhancedAirBook\\Structs\\TicketingInstruction',
            'FuturePricingInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\FuturePricingInfo',
            'FuturePrice' => '\\Sabre\\EnhancedAirBook\\Structs\\FuturePrice',
            'PACInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\PACInfo',
            'PAC' => '\\Sabre\\EnhancedAirBook\\Structs\\PAC',
            'PriceQuoteTotals' => '\\Sabre\\EnhancedAirBook\\Structs\\PriceQuoteTotals',
            'AirTaxi' => '\\Sabre\\EnhancedAirBook\\Structs\\AirTaxi',
            'Vendor' => '\\Sabre\\EnhancedAirBook\\Structs\\Vendor',
            'Arunk' => '\\Sabre\\EnhancedAirBook\\Structs\\Arunk',
            'Cruise' => '\\Sabre\\EnhancedAirBook\\Structs\\Cruise',
            'ServiceInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\ServiceInformation',
            'BSG_Record' => '\\Sabre\\EnhancedAirBook\\Structs\\BSG_Record',
            'CheckInAirline' => '\\Sabre\\EnhancedAirBook\\Structs\\CheckInAirline',
            'CodeshareRecord' => '\\Sabre\\EnhancedAirBook\\Structs\\CodeshareRecord',
            'MarketingCodeshareRecord' => '\\Sabre\\EnhancedAirBook\\Structs\\MarketingCodeshareRecord',
            'Meal' => '\\Sabre\\EnhancedAirBook\\Structs\\Meal',
            'OperatingAirlinePricing' => '\\Sabre\\EnhancedAirBook\\Structs\\OperatingAirlinePricing',
            'OperatingAirlineRecord' => '\\Sabre\\EnhancedAirBook\\Structs\\OperatingAirlineRecord',
            'DisclosureCarrier' => '\\Sabre\\EnhancedAirBook\\Structs\\DisclosureCarrier',
            'SupplierRef' => '\\Sabre\\EnhancedAirBook\\Structs\\SupplierRef',
            'Hotel' => '\\Sabre\\EnhancedAirBook\\Structs\\Hotel',
            'BasicPropertyInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\BasicPropertyInfo',
            'CancelPenalty' => '\\Sabre\\EnhancedAirBook\\Structs\\CancelPenalty',
            'ID' => '\\Sabre\\EnhancedAirBook\\Structs\\ID',
            'RoomRates' => '\\Sabre\\EnhancedAirBook\\Structs\\RoomRates',
            'Rate' => '\\Sabre\\EnhancedAirBook\\Structs\\Rate',
            'AdditionalGuestAmounts' => '\\Sabre\\EnhancedAirBook\\Structs\\AdditionalGuestAmounts',
            'HotelRateDescripton' => '\\Sabre\\EnhancedAirBook\\Structs\\HotelRateDescripton',
            'RateDescriptions' => '\\Sabre\\EnhancedAirBook\\Structs\\RateDescriptions',
            'RateDescription' => '\\Sabre\\EnhancedAirBook\\Structs\\RateDescription',
            'Additionals' => '\\Sabre\\EnhancedAirBook\\Structs\\Additionals',
            'Additional' => '\\Sabre\\EnhancedAirBook\\Structs\\Additional',
            'HotelTotalPricing' => '\\Sabre\\EnhancedAirBook\\Structs\\HotelTotalPricing',
            'TotalSurcharge' => '\\Sabre\\EnhancedAirBook\\Structs\\TotalSurcharge',
            'Surcharge' => '\\Sabre\\EnhancedAirBook\\Structs\\Surcharge',
            'ApproximateTotal' => '\\Sabre\\EnhancedAirBook\\Structs\\ApproximateTotal',
            'RateChange' => '\\Sabre\\EnhancedAirBook\\Structs\\RateChange',
            'Disclaimer' => '\\Sabre\\EnhancedAirBook\\Structs\\Disclaimer',
            'RateAccessCodeBooked' => '\\Sabre\\EnhancedAirBook\\Structs\\RateAccessCodeBooked',
            'SpecialPrefs' => '\\Sabre\\EnhancedAirBook\\Structs\\SpecialPrefs',
            'TimeSpan' => '\\Sabre\\EnhancedAirBook\\Structs\\TimeSpan',
            'Insurance' => '\\Sabre\\EnhancedAirBook\\Structs\\Insurance',
            'InsuranceDetails' => '\\Sabre\\EnhancedAirBook\\Structs\\InsuranceDetails',
            'Coverage' => '\\Sabre\\EnhancedAirBook\\Structs\\Coverage',
            'MiscSegment' => '\\Sabre\\EnhancedAirBook\\Structs\\MiscSegment',
            'Rail' => '\\Sabre\\EnhancedAirBook\\Structs\\Rail',
            'SNCF_Information' => '\\Sabre\\EnhancedAirBook\\Structs\\SNCF_Information',
            'Train' => '\\Sabre\\EnhancedAirBook\\Structs\\Train',
            'Seats' => '\\Sabre\\EnhancedAirBook\\Structs\\Seats',
            'Seat' => '\\Sabre\\EnhancedAirBook\\Structs\\Seat',
            'Surface' => '\\Sabre\\EnhancedAirBook\\Structs\\Surface',
            'Tour' => '\\Sabre\\EnhancedAirBook\\Structs\\Tour',
            'TourDetails' => '\\Sabre\\EnhancedAirBook\\Structs\\TourDetails',
            'Duration' => '\\Sabre\\EnhancedAirBook\\Structs\\Duration',
            'HotelInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\HotelInformation',
            'Room' => '\\Sabre\\EnhancedAirBook\\Structs\\Room',
            'Price' => '\\Sabre\\EnhancedAirBook\\Structs\\Price',
            'VehicleInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\VehicleInformation',
            'Vehicle' => '\\Sabre\\EnhancedAirBook\\Structs\\Vehicle',
            'VehRentalCore' => '\\Sabre\\EnhancedAirBook\\Structs\\VehRentalCore',
            'DropOffLocationDetails' => '\\Sabre\\EnhancedAirBook\\Structs\\DropOffLocationDetails',
            'LocationDetails' => '\\Sabre\\EnhancedAirBook\\Structs\\LocationDetails',
            'VehVendorAvail' => '\\Sabre\\EnhancedAirBook\\Structs\\VehVendorAvail',
            'VehResCore' => '\\Sabre\\EnhancedAirBook\\Structs\\VehResCore',
            'CollectionDeliveryInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\CollectionDeliveryInfo',
            'CollectionInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\CollectionInfo',
            'StateCountyProv' => '\\Sabre\\EnhancedAirBook\\Structs\\StateCountyProv',
            'DeliveryInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\DeliveryInfo',
            'GuaranteePrepaid' => '\\Sabre\\EnhancedAirBook\\Structs\\GuaranteePrepaid',
            'CancellationRefundAmount' => '\\Sabre\\EnhancedAirBook\\Structs\\CancellationRefundAmount',
            'PricedEquip' => '\\Sabre\\EnhancedAirBook\\Structs\\PricedEquip',
            'RentalRate' => '\\Sabre\\EnhancedAirBook\\Structs\\RentalRate',
            'Billing' => '\\Sabre\\EnhancedAirBook\\Structs\\Billing',
            'Client' => '\\Sabre\\EnhancedAirBook\\Structs\\Client',
            'InvoiceRemarks' => '\\Sabre\\EnhancedAirBook\\Structs\\InvoiceRemarks',
            'Remarks' => '\\Sabre\\EnhancedAirBook\\Structs\\Remarks',
            'VehicleTypes' => '\\Sabre\\EnhancedAirBook\\Structs\\VehicleTypes',
            'Voucher' => '\\Sabre\\EnhancedAirBook\\Structs\\Voucher',
            'VehicleCharges' => '\\Sabre\\EnhancedAirBook\\Structs\\VehicleCharges',
            'VehicleCharge' => '\\Sabre\\EnhancedAirBook\\Structs\\VehicleCharge',
            'ApproximateTotalCharge' => '\\Sabre\\EnhancedAirBook\\Structs\\ApproximateTotalCharge',
            'Ancillaries' => '\\Sabre\\EnhancedAirBook\\Structs\\Ancillaries',
            'EquivalentPrice' => '\\Sabre\\EnhancedAirBook\\Structs\\EquivalentPrice',
            'TTLPrice' => '\\Sabre\\EnhancedAirBook\\Structs\\TTLPrice',
            'OriginalBasePrice' => '\\Sabre\\EnhancedAirBook\\Structs\\OriginalBasePrice',
            'TicketCouponNumberAssociation' => '\\Sabre\\EnhancedAirBook\\Structs\\TicketCouponNumberAssociation',
            'TotalOriginalBasePrice' => '\\Sabre\\EnhancedAirBook\\Structs\\TotalOriginalBasePrice',
            'TotalEquivalentPrice' => '\\Sabre\\EnhancedAirBook\\Structs\\TotalEquivalentPrice',
            'TotalTTLPrice' => '\\Sabre\\EnhancedAirBook\\Structs\\TotalTTLPrice',
            'TotalTaxes' => '\\Sabre\\EnhancedAirBook\\Structs\\TotalTaxes',
            'TravelPortions' => '\\Sabre\\EnhancedAirBook\\Structs\\TravelPortions',
            'TravelPortion' => '\\Sabre\\EnhancedAirBook\\Structs\\TravelPortion',
            'ItineraryRef' => '\\Sabre\\EnhancedAirBook\\Structs\\ItineraryRef',
            'TravelPolicy' => '\\Sabre\\EnhancedAirBook\\Structs\\TravelPolicy',
            'PayInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\PayInfo',
            'QueueInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\QueueInfo',
            'Placement' => '\\Sabre\\EnhancedAirBook\\Structs\\Placement',
            'RemarkInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\RemarkInfo',
            'Remark' => '\\Sabre\\EnhancedAirBook\\Structs\\Remark',
            'SpecialServiceInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\SpecialServiceInfo',
            'OpenReservationElements' => '\\Sabre\\EnhancedAirBook\\Structs\\OpenReservationElements',
            'CorporateIDInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\CorporateIDInfo',
            'VCR' => '\\Sabre\\EnhancedAirBook\\Structs\\VCR',
            'TicketingDocument' => '\\Sabre\\EnhancedAirBook\\Structs\\TicketingDocument',
            'ServiceCoupon' => '\\Sabre\\EnhancedAirBook\\Structs\\ServiceCoupon',
            'AssociationMatrix' => '\\Sabre\\EnhancedAirBook\\Structs\\AssociationMatrix',
            'Parent' => '\\Sabre\\EnhancedAirBook\\Structs\\_Parent',
            'Child' => '\\Sabre\\EnhancedAirBook\\Structs\\Child',
            'AssociationMatrices' => '\\Sabre\\EnhancedAirBook\\Structs\\AssociationMatrices',
            'ProductType' => '\\Sabre\\EnhancedAirBook\\Structs\\ProductType',
            'OpenReservationElementsType' => '\\Sabre\\EnhancedAirBook\\Structs\\OpenReservationElementsType',
            'OpenReservationElementType' => '\\Sabre\\EnhancedAirBook\\Structs\\OpenReservationElementType',
            'SocialMediaContactType' => '\\Sabre\\EnhancedAirBook\\Structs\\SocialMediaContactType',
            'AgencyFeesType' => '\\Sabre\\EnhancedAirBook\\Structs\\AgencyFeesType',
            'ProductDetailsType' => '\\Sabre\\EnhancedAirBook\\Structs\\ProductDetailsType',
            'TransactionInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\TransactionInfo',
            'GroundTransportationType' => '\\Sabre\\EnhancedAirBook\\Structs\\GroundTransportationType',
            'CO2ValueType' => '\\Sabre\\EnhancedAirBook\\Structs\\CO2ValueType',
            'ExternalSystemReferenceType' => '\\Sabre\\EnhancedAirBook\\Structs\\ExternalSystemReferenceType',
            'HotelProductType' => '\\Sabre\\EnhancedAirBook\\Structs\\HotelProductType',
            'HotelPolicy' => '\\Sabre\\EnhancedAirBook\\Structs\\HotelPolicy',
            'CheckInCheckOutPolicy' => '\\Sabre\\EnhancedAirBook\\Structs\\CheckInCheckOutPolicy',
            'HotelUniqueIDType' => '\\Sabre\\EnhancedAirBook\\Structs\\HotelUniqueIDType',
            'AdditionalContentType' => '\\Sabre\\EnhancedAirBook\\Structs\\AdditionalContentType',
            'ProductBaseType' => '\\Sabre\\EnhancedAirBook\\Structs\\ProductBaseType',
            'ProductNameType' => '\\Sabre\\EnhancedAirBook\\Structs\\ProductNameType',
            'HotelType' => '\\Sabre\\EnhancedAirBook\\Structs\\HotelType',
            'Reservation' => '\\Sabre\\EnhancedAirBook\\Structs\\Reservation',
            'RoomType' => '\\Sabre\\EnhancedAirBook\\Structs\\RoomType',
            'GuestCounts' => '\\Sabre\\EnhancedAirBook\\Structs\\GuestCounts',
            'Guarantee' => '\\Sabre\\EnhancedAirBook\\Structs\\Guarantee',
            'HotelCode' => '\\Sabre\\EnhancedAirBook\\Structs\\HotelCode',
            'AdditionalInformation' => '\\Sabre\\EnhancedAirBook\\Structs\\AdditionalInformation',
            'ConfirmationNumber' => '\\Sabre\\EnhancedAirBook\\Structs\\ConfirmationNumber',
            'SupplementaryServiceType' => '\\Sabre\\EnhancedAirBook\\Structs\\SupplementaryServiceType',
            'Description' => '\\Sabre\\EnhancedAirBook\\Structs\\Description',
            'PassengerReferences' => '\\Sabre\\EnhancedAirBook\\Structs\\PassengerReferences',
            'PassengerRef' => '\\Sabre\\EnhancedAirBook\\Structs\\PassengerRef',
            'DetailType' => '\\Sabre\\EnhancedAirBook\\Structs\\DetailType',
            'RailwayStationInfoType' => '\\Sabre\\EnhancedAirBook\\Structs\\RailwayStationInfoType',
            'RailAccommodationType' => '\\Sabre\\EnhancedAirBook\\Structs\\RailAccommodationType',
            'Coach' => '\\Sabre\\EnhancedAirBook\\Structs\\Coach',
            'PlacementNumber' => '\\Sabre\\EnhancedAirBook\\Structs\\PlacementNumber',
            'CompanyType' => '\\Sabre\\EnhancedAirBook\\Structs\\CompanyType',
            'Code' => '\\Sabre\\EnhancedAirBook\\Structs\\Code',
            'RailType' => '\\Sabre\\EnhancedAirBook\\Structs\\RailType',
            'MarketingCarrier' => '\\Sabre\\EnhancedAirBook\\Structs\\MarketingCarrier',
            'Passengers' => '\\Sabre\\EnhancedAirBook\\Structs\\Passengers',
            'SupplementaryServices' => '\\Sabre\\EnhancedAirBook\\Structs\\SupplementaryServices',
            'Documents' => '\\Sabre\\EnhancedAirBook\\Structs\\Documents',
            'Details' => '\\Sabre\\EnhancedAirBook\\Structs\\Details',
            'PhoneType' => '\\Sabre\\EnhancedAirBook\\Structs\\PhoneType',
            'TrainDetailsType' => '\\Sabre\\EnhancedAirBook\\Structs\\TrainDetailsType',
            'AddressType' => '\\Sabre\\EnhancedAirBook\\Structs\\AddressType',
            'CityCodes' => '\\Sabre\\EnhancedAirBook\\Structs\\CityCodes',
            'StateProviceCodes' => '\\Sabre\\EnhancedAirBook\\Structs\\StateProviceCodes',
            'CountryCodes' => '\\Sabre\\EnhancedAirBook\\Structs\\CountryCodes',
            'DocumentType' => '\\Sabre\\EnhancedAirBook\\Structs\\DocumentType',
            'SegmentReferences' => '\\Sabre\\EnhancedAirBook\\Structs\\SegmentReferences',
            'SegmentRef' => '\\Sabre\\EnhancedAirBook\\Structs\\SegmentRef',
            'FormOfPayment' => '\\Sabre\\EnhancedAirBook\\Structs\\FormOfPayment',
            'CreditCard' => '\\Sabre\\EnhancedAirBook\\Structs\\CreditCard',
            'CardHolder' => '\\Sabre\\EnhancedAirBook\\Structs\\CardHolder',
            'DocumentRules' => '\\Sabre\\EnhancedAirBook\\Structs\\DocumentRules',
            'Rule' => '\\Sabre\\EnhancedAirBook\\Structs\\Rule',
            'CodeDescriptionType' => '\\Sabre\\EnhancedAirBook\\Structs\\CodeDescriptionType',
            'ServiceType' => '\\Sabre\\EnhancedAirBook\\Structs\\ServiceType',
            'ServiceLevelType' => '\\Sabre\\EnhancedAirBook\\Structs\\ServiceLevelType',
            'EquipmentType' => '\\Sabre\\EnhancedAirBook\\Structs\\EquipmentType',
            'ServiceProviderType' => '\\Sabre\\EnhancedAirBook\\Structs\\ServiceProviderType',
            'LocationDetailsType' => '\\Sabre\\EnhancedAirBook\\Structs\\LocationDetailsType',
            'RailwayStationInfo' => '\\Sabre\\EnhancedAirBook\\Structs\\RailwayStationInfo',
            'StationName' => '\\Sabre\\EnhancedAirBook\\Structs\\StationName',
            'LocalStationName' => '\\Sabre\\EnhancedAirBook\\Structs\\LocalStationName',
            'LocationCodes' => '\\Sabre\\EnhancedAirBook\\Structs\\LocationCodes',
            'Amenities' => '\\Sabre\\EnhancedAirBook\\Structs\\Amenities',
            'AirportInfoType' => '\\Sabre\\EnhancedAirBook\\Structs\\AirportInfoType',
            'AirlineType' => '\\Sabre\\EnhancedAirBook\\Structs\\AirlineType',
            'ExternalReservationType' => '\\Sabre\\EnhancedAirBook\\Structs\\ExternalReservationType',
            'RestrictionsType' => '\\Sabre\\EnhancedAirBook\\Structs\\RestrictionsType',
            'MultilineTextType' => '\\Sabre\\EnhancedAirBook\\Structs\\MultilineTextType',
            'LoyaltyType' => '\\Sabre\\EnhancedAirBook\\Structs\\LoyaltyType',
            'Type' => '\\Sabre\\EnhancedAirBook\\Structs\\Type',
            'RateQualifierType' => '\\Sabre\\EnhancedAirBook\\Structs\\RateQualifierType',
            'SpecialInputType' => '\\Sabre\\EnhancedAirBook\\Structs\\SpecialInputType',
            'ChargesType' => '\\Sabre\\EnhancedAirBook\\Structs\\ChargesType',
            'MoneyType' => '\\Sabre\\EnhancedAirBook\\Structs\\MoneyType',
            'ChargeType' => '\\Sabre\\EnhancedAirBook\\Structs\\ChargeType',
            'CalculationType' => '\\Sabre\\EnhancedAirBook\\Structs\\CalculationType',
            'MinMaxType' => '\\Sabre\\EnhancedAirBook\\Structs\\MinMaxType',
            'POSType' => '\\Sabre\\EnhancedAirBook\\Structs\\POSType',
            'SourceType' => '\\Sabre\\EnhancedAirBook\\Structs\\SourceType',
            'BookingChannelType' => '\\Sabre\\EnhancedAirBook\\Structs\\BookingChannelType',
            'TTYRecordLocatorType' => '\\Sabre\\EnhancedAirBook\\Structs\\TTYRecordLocatorType',
            'OACType' => '\\Sabre\\EnhancedAirBook\\Structs\\OACType',
            'FeeType' => '\\Sabre\\EnhancedAirBook\\Structs\\FeeType',
            'PriceType' => '\\Sabre\\EnhancedAirBook\\Structs\\PriceType',
            'RequestorIDType' => '\\Sabre\\EnhancedAirBook\\Structs\\RequestorIDType',
            'CompanyNameType' => '\\Sabre\\EnhancedAirBook\\Structs\\CompanyNameType',
            'ArrangerDetailsType' => '\\Sabre\\EnhancedAirBook\\Structs\\ArrangerDetailsType',
            'PersonNameType' => '\\Sabre\\EnhancedAirBook\\Structs\\PersonNameType',
            'RailFareType' => '\\Sabre\\EnhancedAirBook\\Structs\\RailFareType',
            'FareDescription' => '\\Sabre\\EnhancedAirBook\\Structs\\FareDescription',
            'Condition' => '\\Sabre\\EnhancedAirBook\\Structs\\Condition',
            'Fees' => '\\Sabre\\EnhancedAirBook\\Structs\\Fees',
            'RequestorSourceType' => '\\Sabre\\EnhancedAirBook\\Structs\\RequestorSourceType',
            'SignatureType' => '\\Sabre\\EnhancedAirBook\\Structs\\SignatureType',
            'SignatureValueType' => '\\Sabre\\EnhancedAirBook\\Structs\\SignatureValueType',
            'SignedInfoType' => '\\Sabre\\EnhancedAirBook\\Structs\\SignedInfoType',
            'CanonicalizationMethodType' => '\\Sabre\\EnhancedAirBook\\Structs\\CanonicalizationMethodType',
            'SignatureMethodType' => '\\Sabre\\EnhancedAirBook\\Structs\\SignatureMethodType',
            'ReferenceType' => '\\Sabre\\EnhancedAirBook\\Structs\\ReferenceType',
            'TransformsType' => '\\Sabre\\EnhancedAirBook\\Structs\\TransformsType',
            'TransformType' => '\\Sabre\\EnhancedAirBook\\Structs\\TransformType',
            'DigestMethodType' => '\\Sabre\\EnhancedAirBook\\Structs\\DigestMethodType',
            'KeyInfoType' => '\\Sabre\\EnhancedAirBook\\Structs\\KeyInfoType',
            'KeyValueType' => '\\Sabre\\EnhancedAirBook\\Structs\\KeyValueType',
            'RetrievalMethodType' => '\\Sabre\\EnhancedAirBook\\Structs\\RetrievalMethodType',
            'X509DataType' => '\\Sabre\\EnhancedAirBook\\Structs\\X509DataType',
            'X509IssuerSerialType' => '\\Sabre\\EnhancedAirBook\\Structs\\X509IssuerSerialType',
            'PGPDataType' => '\\Sabre\\EnhancedAirBook\\Structs\\PGPDataType',
            'SPKIDataType' => '\\Sabre\\EnhancedAirBook\\Structs\\SPKIDataType',
            'ObjectType' => '\\Sabre\\EnhancedAirBook\\Structs\\ObjectType',
            'ManifestType' => '\\Sabre\\EnhancedAirBook\\Structs\\ManifestType',
            'SignaturePropertiesType' => '\\Sabre\\EnhancedAirBook\\Structs\\SignaturePropertiesType',
            'SignaturePropertyType' => '\\Sabre\\EnhancedAirBook\\Structs\\SignaturePropertyType',
            'DSAKeyValueType' => '\\Sabre\\EnhancedAirBook\\Structs\\DSAKeyValueType',
            'RSAKeyValueType' => '\\Sabre\\EnhancedAirBook\\Structs\\RSAKeyValueType',
            'Envelope' => '\\Sabre\\EnhancedAirBook\\Structs\\Envelope',
            'Header' => '\\Sabre\\EnhancedAirBook\\Structs\\Header',
            'Body' => '\\Sabre\\EnhancedAirBook\\Structs\\Body',
            'Fault' => '\\Sabre\\EnhancedAirBook\\Structs\\Fault',
            'detail' => '\\Sabre\\EnhancedAirBook\\Structs\\Detail',
            'Manifest' => '\\Sabre\\EnhancedAirBook\\Structs\\Manifest',
            'Reference' => '\\Sabre\\EnhancedAirBook\\Structs\\Reference',
            'Schema' => '\\Sabre\\EnhancedAirBook\\Structs\\Schema',
            'MessageHeader' => '\\Sabre\\EnhancedAirBook\\Structs\\MessageHeader',
            'MessageData' => '\\Sabre\\EnhancedAirBook\\Structs\\MessageData',
            'SyncReply' => '\\Sabre\\EnhancedAirBook\\Structs\\SyncReply',
            'MessageOrder' => '\\Sabre\\EnhancedAirBook\\Structs\\MessageOrder',
            'AckRequested' => '\\Sabre\\EnhancedAirBook\\Structs\\AckRequested',
            'Acknowledgment' => '\\Sabre\\EnhancedAirBook\\Structs\\Acknowledgment',
            'ErrorList' => '\\Sabre\\EnhancedAirBook\\Structs\\ErrorList',
            'Error' => '\\Sabre\\EnhancedAirBook\\Structs\\Error',
            'StatusResponse' => '\\Sabre\\EnhancedAirBook\\Structs\\StatusResponse',
            'StatusRequest' => '\\Sabre\\EnhancedAirBook\\Structs\\StatusRequest',
            'sequenceNumber.type' => '\\Sabre\\EnhancedAirBook\\Structs\\SequenceNumber_type',
            'PartyId' => '\\Sabre\\EnhancedAirBook\\Structs\\PartyId',
            'To' => '\\Sabre\\EnhancedAirBook\\Structs\\To',
            'From' => '\\Sabre\\EnhancedAirBook\\Structs\\From',
            'Security' => '\\Sabre\\EnhancedAirBook\\Structs\\Security',
            'UsernameToken' => '\\Sabre\\EnhancedAirBook\\Structs\\UsernameToken',
        );
    }
}
