<?php

namespace Sabre\EndTransaction\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Itinerary Structs
 * @subpackage Structs
 */
class Itinerary extends AbstractStructBase
{
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Ind;
    /**
     * The PDF
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EndTransaction\Structs\PDF
     */
    public $PDF;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\EndTransaction\Structs\Segment[]
     */
    public $Segment;
    /**
     * Constructor method for Itinerary
     * @uses Itinerary::setInd()
     * @uses Itinerary::setPDF()
     * @uses Itinerary::setSegment()
     * @param bool $ind
     * @param \Sabre\EndTransaction\Structs\PDF $pDF
     * @param \Sabre\EndTransaction\Structs\Segment[] $segment
     */
    public function __construct($ind = null, \Sabre\EndTransaction\Structs\PDF $pDF = null, array $segment = array())
    {
        $this
            ->setInd($ind)
            ->setPDF($pDF)
            ->setSegment($segment);
    }
    /**
     * Get Ind value
     * @return bool
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\EndTransaction\Structs\Itinerary
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get PDF value
     * @return \Sabre\EndTransaction\Structs\PDF|null
     */
    public function getPDF()
    {
        return $this->PDF;
    }
    /**
     * Set PDF value
     * @param \Sabre\EndTransaction\Structs\PDF $pDF
     * @return \Sabre\EndTransaction\Structs\Itinerary
     */
    public function setPDF(\Sabre\EndTransaction\Structs\PDF $pDF = null)
    {
        $this->PDF = $pDF;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\EndTransaction\Structs\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EndTransaction\Structs\Segment[] $segment
     * @return \Sabre\EndTransaction\Structs\Itinerary
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\EndTransaction\Structs\Segment $item
     * @return \Sabre\EndTransaction\Structs\Itinerary
     */
    public function addToSegment(\Sabre\EndTransaction\Structs\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EndTransaction\Structs\Itinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
