<?php

namespace Sabre\EndTransaction\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndTransactionRS Structs
 * @subpackage Structs
 */
class EndTransactionRS extends AbstractStructBase
{
    /**
     * The ApplicationResults
     * Meta informations extracted from the WSDL
     * - ref: stl:ApplicationResults
     * @var \Sabre\EndTransaction\Structs\ApplicationResults
     */
    public $ApplicationResults;
    /**
     * The ItineraryRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EndTransaction\Structs\ItineraryRef
     */
    public $ItineraryRef;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for EndTransactionRS
     * @uses EndTransactionRS::setApplicationResults()
     * @uses EndTransactionRS::setItineraryRef()
     * @uses EndTransactionRS::setText()
     * @uses EndTransactionRS::setVersion()
     * @param \Sabre\EndTransaction\Structs\ApplicationResults $applicationResults
     * @param \Sabre\EndTransaction\Structs\ItineraryRef $itineraryRef
     * @param string[] $text
     * @param string $version
     */
    public function __construct(\Sabre\EndTransaction\Structs\ApplicationResults $applicationResults = null, \Sabre\EndTransaction\Structs\ItineraryRef $itineraryRef = null, array $text = array(), $version = null)
    {
        $this
            ->setApplicationResults($applicationResults)
            ->setItineraryRef($itineraryRef)
            ->setText($text)
            ->setVersion($version);
    }
    /**
     * Get ApplicationResults value
     * @return \Sabre\EndTransaction\Structs\ApplicationResults|null
     */
    public function getApplicationResults()
    {
        return $this->ApplicationResults;
    }
    /**
     * Set ApplicationResults value
     * @param \Sabre\EndTransaction\Structs\ApplicationResults $applicationResults
     * @return \Sabre\EndTransaction\Structs\EndTransactionRS
     */
    public function setApplicationResults(\Sabre\EndTransaction\Structs\ApplicationResults $applicationResults = null)
    {
        $this->ApplicationResults = $applicationResults;
        return $this;
    }
    /**
     * Get ItineraryRef value
     * @return \Sabre\EndTransaction\Structs\ItineraryRef|null
     */
    public function getItineraryRef()
    {
        return $this->ItineraryRef;
    }
    /**
     * Set ItineraryRef value
     * @param \Sabre\EndTransaction\Structs\ItineraryRef $itineraryRef
     * @return \Sabre\EndTransaction\Structs\EndTransactionRS
     */
    public function setItineraryRef(\Sabre\EndTransaction\Structs\ItineraryRef $itineraryRef = null)
    {
        $this->ItineraryRef = $itineraryRef;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\EndTransaction\Structs\EndTransactionRS
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\EndTransaction\Structs\EndTransactionRS
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\EndTransaction\Structs\EndTransactionRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EndTransaction\Structs\EndTransactionRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
