<?php

namespace Sabre\EndTransaction\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndTransactionRQ Structs
 * @subpackage Structs
 */
class EndTransactionRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - fixed: 2.0.7
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The EndTransaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EndTransaction\Structs\EndTransaction
     */
    public $EndTransaction;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\EndTransaction\Structs\Source
     */
    public $Source;
    /**
     * The ReturnHostCommand
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReturnHostCommand;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for EndTransactionRQ
     * @uses EndTransactionRQ::setVersion()
     * @uses EndTransactionRQ::setEndTransaction()
     * @uses EndTransactionRQ::setSource()
     * @uses EndTransactionRQ::setReturnHostCommand()
     * @uses EndTransactionRQ::setTimeStamp()
     * @param string $version
     * @param \Sabre\EndTransaction\Structs\EndTransaction $endTransaction
     * @param \Sabre\EndTransaction\Structs\Source $source
     * @param bool $returnHostCommand
     * @param string $timeStamp
     */
    public function __construct($version = null, \Sabre\EndTransaction\Structs\EndTransaction $endTransaction = null, \Sabre\EndTransaction\Structs\Source $source = null, $returnHostCommand = null, $timeStamp = null)
    {
        $this
            ->setVersion($version)
            ->setEndTransaction($endTransaction)
            ->setSource($source)
            ->setReturnHostCommand($returnHostCommand)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\EndTransaction\Structs\EndTransactionRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get EndTransaction value
     * @return \Sabre\EndTransaction\Structs\EndTransaction|null
     */
    public function getEndTransaction()
    {
        return $this->EndTransaction;
    }
    /**
     * Set EndTransaction value
     * @param \Sabre\EndTransaction\Structs\EndTransaction $endTransaction
     * @return \Sabre\EndTransaction\Structs\EndTransactionRQ
     */
    public function setEndTransaction(\Sabre\EndTransaction\Structs\EndTransaction $endTransaction = null)
    {
        $this->EndTransaction = $endTransaction;
        return $this;
    }
    /**
     * Get Source value
     * @return \Sabre\EndTransaction\Structs\Source|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \Sabre\EndTransaction\Structs\Source $source
     * @return \Sabre\EndTransaction\Structs\EndTransactionRQ
     */
    public function setSource(\Sabre\EndTransaction\Structs\Source $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get ReturnHostCommand value
     * @return bool|null
     */
    public function getReturnHostCommand()
    {
        return $this->ReturnHostCommand;
    }
    /**
     * Set ReturnHostCommand value
     * @param bool $returnHostCommand
     * @return \Sabre\EndTransaction\Structs\EndTransactionRQ
     */
    public function setReturnHostCommand($returnHostCommand = null)
    {
        $this->ReturnHostCommand = $returnHostCommand;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\EndTransaction\Structs\EndTransactionRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\EndTransaction\Structs\EndTransactionRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
