<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/EndTransactionLLS2.0.7RQ.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/EndTransactionLLS2.0.7RQ.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sabre\EndTransaction\ClassMap::get(),
);
/**
 * Samples for End ServiceType
 */
$end = new \Sabre\EndTransaction\Services\End($options);
$end->setSoapHeaderMessageHeader(new \Sabre\EndTransaction\Structs\MessageHeader());
$end->setSoapHeaderSecurity(new \Sabre\EndTransaction\Structs\Security());
/**
 * Sample call for EndTransactionRQ operation/method
 */
if ($end->EndTransactionRQ(new \Sabre\EndTransaction\Structs\EndTransactionRQ()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
