<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax Structs
 * @subpackage Structs
 */
class Tax extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to specify the tax amount. | "Amount" is used to specify the tax amount. | "Amount" is used to specify the tax amount. | "Amount" is used to specify the tax amount.
     * - use: required
     * @var string
     */
    public $Amount;
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - documentation: "TaxCode" is used to specify the tax code. | "TaxCode" is used to specify the tax code. | "TaxCode" is used to specify the tax code. | "TaxCode" is used to specify the tax code.
     * - use: required
     * @var string
     */
    public $TaxCode;
    /**
     * Constructor method for Tax
     * @uses Tax::setAmount()
     * @uses Tax::setTaxCode()
     * @param string $amount
     * @param string $taxCode
     */
    public function __construct($amount = null, $taxCode = null)
    {
        $this
            ->setAmount($amount)
            ->setTaxCode($taxCode);
    }
    /**
     * Get Amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\AirTicket\Structs\Tax
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \Sabre\AirTicket\Structs\Tax
     */
    public function setTaxCode($taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Tax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
