<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentSelect Structs
 * @subpackage Structs
 */
class SegmentSelect extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The EndNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $EndNumber;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used to match up with ".../SpecificFare/@RPH" or .../Brand.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for SegmentSelect
     * @uses SegmentSelect::setNumber()
     * @uses SegmentSelect::setEndNumber()
     * @uses SegmentSelect::setRPH()
     * @param int $number
     * @param int $endNumber
     * @param string $rPH
     */
    public function __construct($number = null, $endNumber = null, $rPH = null)
    {
        $this
            ->setNumber($number)
            ->setEndNumber($endNumber)
            ->setRPH($rPH);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\AirTicket\Structs\SegmentSelect
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get EndNumber value
     * @return int|null
     */
    public function getEndNumber()
    {
        return $this->EndNumber;
    }
    /**
     * Set EndNumber value
     * @param int $endNumber
     * @return \Sabre\AirTicket\Structs\SegmentSelect
     */
    public function setEndNumber($endNumber = null)
    {
        $this->EndNumber = $endNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\AirTicket\Structs\SegmentSelect
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\SegmentSelect
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
