<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingQualifiers Structs
 * @subpackage Structs
 */
class PricingQualifiers extends AbstractStructBase
{
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Brand[]
     */
    public $Brand;
    /**
     * The FareFocusExclude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\FareFocusExclude
     */
    public $FareFocusExclude;
    /**
     * The Fare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Fare
     */
    public $Fare;
    /**
     * The ItineraryOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\ItineraryOptions
     */
    public $ItineraryOptions;
    /**
     * The NameSelect
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\NameSelect[]
     */
    public $NameSelect;
    /**
     * The PhaseIV
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\PhaseIV[]
     */
    public $PhaseIV;
    /**
     * The PriceQuote
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\PriceQuote[]
     */
    public $PriceQuote;
    /**
     * The SpanishLargeFamilyDiscountLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpanishLargeFamilyDiscountLevel;
    /**
     * The SpecificFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\SpecificFare[]
     */
    public $SpecificFare;
    /**
     * The SpecificPenalty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\SpecificPenalty
     */
    public $SpecificPenalty;
    /**
     * The ValidityDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\ValidityDates[]
     */
    public $ValidityDates;
    /**
     * Constructor method for PricingQualifiers
     * @uses PricingQualifiers::setBrand()
     * @uses PricingQualifiers::setFareFocusExclude()
     * @uses PricingQualifiers::setFare()
     * @uses PricingQualifiers::setItineraryOptions()
     * @uses PricingQualifiers::setNameSelect()
     * @uses PricingQualifiers::setPhaseIV()
     * @uses PricingQualifiers::setPriceQuote()
     * @uses PricingQualifiers::setSpanishLargeFamilyDiscountLevel()
     * @uses PricingQualifiers::setSpecificFare()
     * @uses PricingQualifiers::setSpecificPenalty()
     * @uses PricingQualifiers::setValidityDates()
     * @param \Sabre\AirTicket\Structs\Brand[] $brand
     * @param \Sabre\AirTicket\Structs\FareFocusExclude $fareFocusExclude
     * @param \Sabre\AirTicket\Structs\Fare $fare
     * @param \Sabre\AirTicket\Structs\ItineraryOptions $itineraryOptions
     * @param \Sabre\AirTicket\Structs\NameSelect[] $nameSelect
     * @param \Sabre\AirTicket\Structs\PhaseIV[] $phaseIV
     * @param \Sabre\AirTicket\Structs\PriceQuote[] $priceQuote
     * @param string $spanishLargeFamilyDiscountLevel
     * @param \Sabre\AirTicket\Structs\SpecificFare[] $specificFare
     * @param \Sabre\AirTicket\Structs\SpecificPenalty $specificPenalty
     * @param \Sabre\AirTicket\Structs\ValidityDates[] $validityDates
     */
    public function __construct(array $brand = array(), \Sabre\AirTicket\Structs\FareFocusExclude $fareFocusExclude = null, \Sabre\AirTicket\Structs\Fare $fare = null, \Sabre\AirTicket\Structs\ItineraryOptions $itineraryOptions = null, array $nameSelect = array(), array $phaseIV = array(), array $priceQuote = array(), $spanishLargeFamilyDiscountLevel = null, array $specificFare = array(), \Sabre\AirTicket\Structs\SpecificPenalty $specificPenalty = null, array $validityDates = array())
    {
        $this
            ->setBrand($brand)
            ->setFareFocusExclude($fareFocusExclude)
            ->setFare($fare)
            ->setItineraryOptions($itineraryOptions)
            ->setNameSelect($nameSelect)
            ->setPhaseIV($phaseIV)
            ->setPriceQuote($priceQuote)
            ->setSpanishLargeFamilyDiscountLevel($spanishLargeFamilyDiscountLevel)
            ->setSpecificFare($specificFare)
            ->setSpecificPenalty($specificPenalty)
            ->setValidityDates($validityDates);
    }
    /**
     * Get Brand value
     * @return \Sabre\AirTicket\Structs\Brand[]|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Brand[] $brand
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setBrand(array $brand = array())
    {
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Add item to Brand value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Brand $item
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function addToBrand(\Sabre\AirTicket\Structs\Brand $item)
    {
        $this->Brand[] = $item;
        return $this;
    }
    /**
     * Get FareFocusExclude value
     * @return \Sabre\AirTicket\Structs\FareFocusExclude|null
     */
    public function getFareFocusExclude()
    {
        return $this->FareFocusExclude;
    }
    /**
     * Set FareFocusExclude value
     * @param \Sabre\AirTicket\Structs\FareFocusExclude $fareFocusExclude
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setFareFocusExclude(\Sabre\AirTicket\Structs\FareFocusExclude $fareFocusExclude = null)
    {
        $this->FareFocusExclude = $fareFocusExclude;
        return $this;
    }
    /**
     * Get Fare value
     * @return \Sabre\AirTicket\Structs\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \Sabre\AirTicket\Structs\Fare $fare
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setFare(\Sabre\AirTicket\Structs\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get ItineraryOptions value
     * @return \Sabre\AirTicket\Structs\ItineraryOptions|null
     */
    public function getItineraryOptions()
    {
        return $this->ItineraryOptions;
    }
    /**
     * Set ItineraryOptions value
     * @param \Sabre\AirTicket\Structs\ItineraryOptions $itineraryOptions
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setItineraryOptions(\Sabre\AirTicket\Structs\ItineraryOptions $itineraryOptions = null)
    {
        $this->ItineraryOptions = $itineraryOptions;
        return $this;
    }
    /**
     * Get NameSelect value
     * @return \Sabre\AirTicket\Structs\NameSelect[]|null
     */
    public function getNameSelect()
    {
        return $this->NameSelect;
    }
    /**
     * Set NameSelect value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\NameSelect[] $nameSelect
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setNameSelect(array $nameSelect = array())
    {
        $this->NameSelect = $nameSelect;
        return $this;
    }
    /**
     * Add item to NameSelect value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\NameSelect $item
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function addToNameSelect(\Sabre\AirTicket\Structs\NameSelect $item)
    {
        $this->NameSelect[] = $item;
        return $this;
    }
    /**
     * Get PhaseIV value
     * @return \Sabre\AirTicket\Structs\PhaseIV[]|null
     */
    public function getPhaseIV()
    {
        return $this->PhaseIV;
    }
    /**
     * Set PhaseIV value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\PhaseIV[] $phaseIV
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setPhaseIV(array $phaseIV = array())
    {
        $this->PhaseIV = $phaseIV;
        return $this;
    }
    /**
     * Add item to PhaseIV value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\PhaseIV $item
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function addToPhaseIV(\Sabre\AirTicket\Structs\PhaseIV $item)
    {
        $this->PhaseIV[] = $item;
        return $this;
    }
    /**
     * Get PriceQuote value
     * @return \Sabre\AirTicket\Structs\PriceQuote[]|null
     */
    public function getPriceQuote()
    {
        return $this->PriceQuote;
    }
    /**
     * Set PriceQuote value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\PriceQuote[] $priceQuote
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setPriceQuote(array $priceQuote = array())
    {
        $this->PriceQuote = $priceQuote;
        return $this;
    }
    /**
     * Add item to PriceQuote value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\PriceQuote $item
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function addToPriceQuote(\Sabre\AirTicket\Structs\PriceQuote $item)
    {
        $this->PriceQuote[] = $item;
        return $this;
    }
    /**
     * Get SpanishLargeFamilyDiscountLevel value
     * @return string|null
     */
    public function getSpanishLargeFamilyDiscountLevel()
    {
        return $this->SpanishLargeFamilyDiscountLevel;
    }
    /**
     * Set SpanishLargeFamilyDiscountLevel value
     * @uses \Sabre\AirTicket\Enums\SpanishLargeFamilyDiscountLevel::valueIsValid()
     * @uses \Sabre\AirTicket\Enums\SpanishLargeFamilyDiscountLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $spanishLargeFamilyDiscountLevel
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setSpanishLargeFamilyDiscountLevel($spanishLargeFamilyDiscountLevel = null)
    {
        $this->SpanishLargeFamilyDiscountLevel = $spanishLargeFamilyDiscountLevel;
        return $this;
    }
    /**
     * Get SpecificFare value
     * @return \Sabre\AirTicket\Structs\SpecificFare[]|null
     */
    public function getSpecificFare()
    {
        return $this->SpecificFare;
    }
    /**
     * Set SpecificFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\SpecificFare[] $specificFare
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setSpecificFare(array $specificFare = array())
    {
        $this->SpecificFare = $specificFare;
        return $this;
    }
    /**
     * Add item to SpecificFare value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\SpecificFare $item
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function addToSpecificFare(\Sabre\AirTicket\Structs\SpecificFare $item)
    {
        $this->SpecificFare[] = $item;
        return $this;
    }
    /**
     * Get SpecificPenalty value
     * @return \Sabre\AirTicket\Structs\SpecificPenalty|null
     */
    public function getSpecificPenalty()
    {
        return $this->SpecificPenalty;
    }
    /**
     * Set SpecificPenalty value
     * @param \Sabre\AirTicket\Structs\SpecificPenalty $specificPenalty
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setSpecificPenalty(\Sabre\AirTicket\Structs\SpecificPenalty $specificPenalty = null)
    {
        $this->SpecificPenalty = $specificPenalty;
        return $this;
    }
    /**
     * Get ValidityDates value
     * @return \Sabre\AirTicket\Structs\ValidityDates[]|null
     */
    public function getValidityDates()
    {
        return $this->ValidityDates;
    }
    /**
     * Set ValidityDates value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\ValidityDates[] $validityDates
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function setValidityDates(array $validityDates = array())
    {
        $this->ValidityDates = $validityDates;
        return $this;
    }
    /**
     * Add item to ValidityDates value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\ValidityDates $item
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public function addToValidityDates(\Sabre\AirTicket\Structs\ValidityDates $item)
    {
        $this->ValidityDates[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\PricingQualifiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
