<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayLaterPlan Structs
 * Meta informations extracted from the WSDL
 * - documentation: "PayLaterPlan" is only applicable to Brazil, cannot combine with MultipleFOP, or MultipleMiscFOP.
 * @subpackage Structs
 */
class PayLaterPlan extends AbstractStructBase
{
    /**
     * The Fare
     * @var \Sabre\AirTicket\Structs\Fare
     */
    public $Fare;
    /**
     * The FOP
     * @var \Sabre\AirTicket\Structs\FOP
     */
    public $FOP;
    /**
     * The Installment
     * @var \Sabre\AirTicket\Structs\Installment
     */
    public $Installment;
    /**
     * Constructor method for PayLaterPlan
     * @uses PayLaterPlan::setFare()
     * @uses PayLaterPlan::setFOP()
     * @uses PayLaterPlan::setInstallment()
     * @param \Sabre\AirTicket\Structs\Fare $fare
     * @param \Sabre\AirTicket\Structs\FOP $fOP
     * @param \Sabre\AirTicket\Structs\Installment $installment
     */
    public function __construct(\Sabre\AirTicket\Structs\Fare $fare = null, \Sabre\AirTicket\Structs\FOP $fOP = null, \Sabre\AirTicket\Structs\Installment $installment = null)
    {
        $this
            ->setFare($fare)
            ->setFOP($fOP)
            ->setInstallment($installment);
    }
    /**
     * Get Fare value
     * @return \Sabre\AirTicket\Structs\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \Sabre\AirTicket\Structs\Fare $fare
     * @return \Sabre\AirTicket\Structs\PayLaterPlan
     */
    public function setFare(\Sabre\AirTicket\Structs\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get FOP value
     * @return \Sabre\AirTicket\Structs\FOP|null
     */
    public function getFOP()
    {
        return $this->FOP;
    }
    /**
     * Set FOP value
     * @param \Sabre\AirTicket\Structs\FOP $fOP
     * @return \Sabre\AirTicket\Structs\PayLaterPlan
     */
    public function setFOP(\Sabre\AirTicket\Structs\FOP $fOP = null)
    {
        $this->FOP = $fOP;
        return $this;
    }
    /**
     * Get Installment value
     * @return \Sabre\AirTicket\Structs\Installment|null
     */
    public function getInstallment()
    {
        return $this->Installment;
    }
    /**
     * Set Installment value
     * @param \Sabre\AirTicket\Structs\Installment $installment
     * @return \Sabre\AirTicket\Structs\PayLaterPlan
     */
    public function setInstallment(\Sabre\AirTicket\Structs\Installment $installment = null)
    {
        $this->Installment = $installment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\PayLaterPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
