<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NeedPrint Structs
 * Meta informations extracted from the WSDL
 * - documentation: Please note that only two of the three attributes can be set to true simultaneously.
 * @subpackage Structs
 */
class NeedPrint extends AbstractStructBase
{
    /**
     * The AuditorCoupon
     * Meta informations extracted from the WSDL
     * - documentation: "AuditorCoupon" is used to specify to print an auditor coupon. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
     * - use: required
     * @var bool
     */
    public $AuditorCoupon;
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - documentation: "Itinerary" is used to specify to print an itinerary. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
     * - use: required
     * @var bool
     */
    public $Itinerary;
    /**
     * The PassengerReceipt
     * Meta informations extracted from the WSDL
     * - documentation: "PassengerReceipt" is used to specify to print a passenger receipt. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
     * - use: required
     * @var bool
     */
    public $PassengerReceipt;
    /**
     * Constructor method for NeedPrint
     * @uses NeedPrint::setAuditorCoupon()
     * @uses NeedPrint::setItinerary()
     * @uses NeedPrint::setPassengerReceipt()
     * @param bool $auditorCoupon
     * @param bool $itinerary
     * @param bool $passengerReceipt
     */
    public function __construct($auditorCoupon = null, $itinerary = null, $passengerReceipt = null)
    {
        $this
            ->setAuditorCoupon($auditorCoupon)
            ->setItinerary($itinerary)
            ->setPassengerReceipt($passengerReceipt);
    }
    /**
     * Get AuditorCoupon value
     * @return bool
     */
    public function getAuditorCoupon()
    {
        return $this->AuditorCoupon;
    }
    /**
     * Set AuditorCoupon value
     * @param bool $auditorCoupon
     * @return \Sabre\AirTicket\Structs\NeedPrint
     */
    public function setAuditorCoupon($auditorCoupon = null)
    {
        $this->AuditorCoupon = $auditorCoupon;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return bool
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param bool $itinerary
     * @return \Sabre\AirTicket\Structs\NeedPrint
     */
    public function setItinerary($itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get PassengerReceipt value
     * @return bool
     */
    public function getPassengerReceipt()
    {
        return $this->PassengerReceipt;
    }
    /**
     * Set PassengerReceipt value
     * @param bool $passengerReceipt
     * @return \Sabre\AirTicket\Structs\NeedPrint
     */
    public function setPassengerReceipt($passengerReceipt = null)
    {
        $this->PassengerReceipt = $passengerReceipt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\NeedPrint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
