<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscQualifiers Structs
 * @subpackage Structs
 */
class MiscQualifiers extends AbstractStructBase
{
    /**
     * The AirExtras
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\AirExtras[]
     */
    public $AirExtras;
    /**
     * The BaggageAllowance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\BaggageAllowance
     */
    public $BaggageAllowance;
    /**
     * The Certificate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Certificate[]
     */
    public $Certificate;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Commission
     */
    public $Commission;
    /**
     * The DateOfBirth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $DateOfBirth;
    /**
     * The Endorsement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Endorsement
     */
    public $Endorsement;
    /**
     * The FutureTicket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\FutureTicket
     */
    public $FutureTicket;
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Invoice
     */
    public $Invoice;
    /**
     * The NeedPrint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\NeedPrint
     */
    public $NeedPrint;
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Ticket
     */
    public $Ticket;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\TourCode
     */
    public $TourCode;
    /**
     * Constructor method for MiscQualifiers
     * @uses MiscQualifiers::setAirExtras()
     * @uses MiscQualifiers::setBaggageAllowance()
     * @uses MiscQualifiers::setCertificate()
     * @uses MiscQualifiers::setCommission()
     * @uses MiscQualifiers::setDateOfBirth()
     * @uses MiscQualifiers::setEndorsement()
     * @uses MiscQualifiers::setFutureTicket()
     * @uses MiscQualifiers::setInvoice()
     * @uses MiscQualifiers::setNeedPrint()
     * @uses MiscQualifiers::setTicket()
     * @uses MiscQualifiers::setTourCode()
     * @param \Sabre\AirTicket\Structs\AirExtras[] $airExtras
     * @param \Sabre\AirTicket\Structs\BaggageAllowance $baggageAllowance
     * @param \Sabre\AirTicket\Structs\Certificate[] $certificate
     * @param \Sabre\AirTicket\Structs\Commission $commission
     * @param mixed $dateOfBirth
     * @param \Sabre\AirTicket\Structs\Endorsement $endorsement
     * @param \Sabre\AirTicket\Structs\FutureTicket $futureTicket
     * @param \Sabre\AirTicket\Structs\Invoice $invoice
     * @param \Sabre\AirTicket\Structs\NeedPrint $needPrint
     * @param \Sabre\AirTicket\Structs\Ticket $ticket
     * @param \Sabre\AirTicket\Structs\TourCode $tourCode
     */
    public function __construct(array $airExtras = array(), \Sabre\AirTicket\Structs\BaggageAllowance $baggageAllowance = null, array $certificate = array(), \Sabre\AirTicket\Structs\Commission $commission = null, $dateOfBirth = null, \Sabre\AirTicket\Structs\Endorsement $endorsement = null, \Sabre\AirTicket\Structs\FutureTicket $futureTicket = null, \Sabre\AirTicket\Structs\Invoice $invoice = null, \Sabre\AirTicket\Structs\NeedPrint $needPrint = null, \Sabre\AirTicket\Structs\Ticket $ticket = null, \Sabre\AirTicket\Structs\TourCode $tourCode = null)
    {
        $this
            ->setAirExtras($airExtras)
            ->setBaggageAllowance($baggageAllowance)
            ->setCertificate($certificate)
            ->setCommission($commission)
            ->setDateOfBirth($dateOfBirth)
            ->setEndorsement($endorsement)
            ->setFutureTicket($futureTicket)
            ->setInvoice($invoice)
            ->setNeedPrint($needPrint)
            ->setTicket($ticket)
            ->setTourCode($tourCode);
    }
    /**
     * Get AirExtras value
     * @return \Sabre\AirTicket\Structs\AirExtras[]|null
     */
    public function getAirExtras()
    {
        return $this->AirExtras;
    }
    /**
     * Set AirExtras value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\AirExtras[] $airExtras
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setAirExtras(array $airExtras = array())
    {
        $this->AirExtras = $airExtras;
        return $this;
    }
    /**
     * Add item to AirExtras value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\AirExtras $item
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function addToAirExtras(\Sabre\AirTicket\Structs\AirExtras $item)
    {
        $this->AirExtras[] = $item;
        return $this;
    }
    /**
     * Get BaggageAllowance value
     * @return \Sabre\AirTicket\Structs\BaggageAllowance|null
     */
    public function getBaggageAllowance()
    {
        return $this->BaggageAllowance;
    }
    /**
     * Set BaggageAllowance value
     * @param \Sabre\AirTicket\Structs\BaggageAllowance $baggageAllowance
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setBaggageAllowance(\Sabre\AirTicket\Structs\BaggageAllowance $baggageAllowance = null)
    {
        $this->BaggageAllowance = $baggageAllowance;
        return $this;
    }
    /**
     * Get Certificate value
     * @return \Sabre\AirTicket\Structs\Certificate[]|null
     */
    public function getCertificate()
    {
        return $this->Certificate;
    }
    /**
     * Set Certificate value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Certificate[] $certificate
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setCertificate(array $certificate = array())
    {
        $this->Certificate = $certificate;
        return $this;
    }
    /**
     * Add item to Certificate value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Certificate $item
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function addToCertificate(\Sabre\AirTicket\Structs\Certificate $item)
    {
        $this->Certificate[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \Sabre\AirTicket\Structs\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \Sabre\AirTicket\Structs\Commission $commission
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setCommission(\Sabre\AirTicket\Structs\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return mixed|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param mixed $dateOfBirth
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Endorsement value
     * @return \Sabre\AirTicket\Structs\Endorsement|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * Set Endorsement value
     * @param \Sabre\AirTicket\Structs\Endorsement $endorsement
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setEndorsement(\Sabre\AirTicket\Structs\Endorsement $endorsement = null)
    {
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Get FutureTicket value
     * @return \Sabre\AirTicket\Structs\FutureTicket|null
     */
    public function getFutureTicket()
    {
        return $this->FutureTicket;
    }
    /**
     * Set FutureTicket value
     * @param \Sabre\AirTicket\Structs\FutureTicket $futureTicket
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setFutureTicket(\Sabre\AirTicket\Structs\FutureTicket $futureTicket = null)
    {
        $this->FutureTicket = $futureTicket;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Sabre\AirTicket\Structs\Invoice|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Sabre\AirTicket\Structs\Invoice $invoice
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setInvoice(\Sabre\AirTicket\Structs\Invoice $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get NeedPrint value
     * @return \Sabre\AirTicket\Structs\NeedPrint|null
     */
    public function getNeedPrint()
    {
        return $this->NeedPrint;
    }
    /**
     * Set NeedPrint value
     * @param \Sabre\AirTicket\Structs\NeedPrint $needPrint
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setNeedPrint(\Sabre\AirTicket\Structs\NeedPrint $needPrint = null)
    {
        $this->NeedPrint = $needPrint;
        return $this;
    }
    /**
     * Get Ticket value
     * @return \Sabre\AirTicket\Structs\Ticket|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param \Sabre\AirTicket\Structs\Ticket $ticket
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setTicket(\Sabre\AirTicket\Structs\Ticket $ticket = null)
    {
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get TourCode value
     * @return \Sabre\AirTicket\Structs\TourCode|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param \Sabre\AirTicket\Structs\TourCode $tourCode
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public function setTourCode(\Sabre\AirTicket\Structs\TourCode $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\MiscQualifiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
