<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Line Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Line" and its associated attributes are used to issue tickets from specific FP lines.
 * @subpackage Structs
 */
class Line extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The EndNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $EndNumber;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * Constructor method for Line
     * @uses Line::setNumber()
     * @uses Line::setEndNumber()
     * @uses Line::setNameNumber()
     * @param int $number
     * @param int $endNumber
     * @param string $nameNumber
     */
    public function __construct($number = null, $endNumber = null, $nameNumber = null)
    {
        $this
            ->setNumber($number)
            ->setEndNumber($endNumber)
            ->setNameNumber($nameNumber);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\AirTicket\Structs\Line
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get EndNumber value
     * @return int|null
     */
    public function getEndNumber()
    {
        return $this->EndNumber;
    }
    /**
     * Set EndNumber value
     * @param int $endNumber
     * @return \Sabre\AirTicket\Structs\Line
     */
    public function setEndNumber($endNumber = null)
    {
        $this->EndNumber = $endNumber;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\AirTicket\Structs\Line
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Line
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
