<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hardcopy Structs
 * @subpackage Structs
 */
class Hardcopy extends AbstractStructBase
{
    /**
     * The Spacing
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Spacing;
    /**
     * The LNIATA
     * Meta informations extracted from the WSDL
     * - documentation: "LNIATA" is used to specify a bag tag printer address.
     * - use: optional
     * @var string
     */
    public $LNIATA;
    /**
     * Constructor method for Hardcopy
     * @uses Hardcopy::setSpacing()
     * @uses Hardcopy::setLNIATA()
     * @param string $spacing
     * @param string $lNIATA
     */
    public function __construct($spacing = null, $lNIATA = null)
    {
        $this
            ->setSpacing($spacing)
            ->setLNIATA($lNIATA);
    }
    /**
     * Get Spacing value
     * @return string|null
     */
    public function getSpacing()
    {
        return $this->Spacing;
    }
    /**
     * Set Spacing value
     * @param string $spacing
     * @return \Sabre\AirTicket\Structs\Hardcopy
     */
    public function setSpacing($spacing = null)
    {
        $this->Spacing = $spacing;
        return $this;
    }
    /**
     * Get LNIATA value
     * @return string|null
     */
    public function getLNIATA()
    {
        return $this->LNIATA;
    }
    /**
     * Set LNIATA value
     * @param string $lNIATA
     * @return \Sabre\AirTicket\Structs\Hardcopy
     */
    public function setLNIATA($lNIATA = null)
    {
        $this->LNIATA = $lNIATA;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Hardcopy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
