<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EitherOr Structs
 * Meta informations extracted from the WSDL
 * - documentation: It is not possible to combine "BeforeDeparture" and "AfterDeparture" within one element.
 * @subpackage Structs
 */
class EitherOr extends AbstractStructBase
{
    /**
     * The Any
     * Meta informations extracted from the WSDL
     * - documentation: "Any" is used to specify only changeable fare options.
     * - use: optional
     * @var bool
     */
    public $Any;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to specify the specific currency for maximum exchange penalty.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MaxPenalty
     * Meta informations extracted from the WSDL
     * - documentation: "MaxPenalty" is used to specify maximum change penalty. If a value of "0" is input no penalty is preferred. If a value of "N" is input only non-changeable options are requested. Please note that monetary amount that includes a
     * decimal is not allowed
     * - use: optional
     * @var string
     */
    public $MaxPenalty;
    /**
     * The BeforeDeparture
     * Meta informations extracted from the WSDL
     * - documentation: "BeforeDeparture" is used to query for before depature fees.
     * - use: optional
     * @var bool
     */
    public $BeforeDeparture;
    /**
     * The AfterDeparture
     * Meta informations extracted from the WSDL
     * - documentation: "AfterDeparture" is used to query for after depature fees.
     * - use: optional
     * @var bool
     */
    public $AfterDeparture;
    /**
     * Constructor method for EitherOr
     * @uses EitherOr::setAny()
     * @uses EitherOr::setCurrencyCode()
     * @uses EitherOr::setMaxPenalty()
     * @uses EitherOr::setBeforeDeparture()
     * @uses EitherOr::setAfterDeparture()
     * @param bool $any
     * @param string $currencyCode
     * @param string $maxPenalty
     * @param bool $beforeDeparture
     * @param bool $afterDeparture
     */
    public function __construct($any = null, $currencyCode = null, $maxPenalty = null, $beforeDeparture = null, $afterDeparture = null)
    {
        $this
            ->setAny($any)
            ->setCurrencyCode($currencyCode)
            ->setMaxPenalty($maxPenalty)
            ->setBeforeDeparture($beforeDeparture)
            ->setAfterDeparture($afterDeparture);
    }
    /**
     * Get Any value
     * @return bool|null
     */
    public function getAny()
    {
        return $this->Any;
    }
    /**
     * Set Any value
     * @param bool $any
     * @return \Sabre\AirTicket\Structs\EitherOr
     */
    public function setAny($any = null)
    {
        $this->Any = $any;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\AirTicket\Structs\EitherOr
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MaxPenalty value
     * @return string|null
     */
    public function getMaxPenalty()
    {
        return $this->MaxPenalty;
    }
    /**
     * Set MaxPenalty value
     * @param string $maxPenalty
     * @return \Sabre\AirTicket\Structs\EitherOr
     */
    public function setMaxPenalty($maxPenalty = null)
    {
        $this->MaxPenalty = $maxPenalty;
        return $this;
    }
    /**
     * Get BeforeDeparture value
     * @return bool|null
     */
    public function getBeforeDeparture()
    {
        return $this->BeforeDeparture;
    }
    /**
     * Set BeforeDeparture value
     * @param bool $beforeDeparture
     * @return \Sabre\AirTicket\Structs\EitherOr
     */
    public function setBeforeDeparture($beforeDeparture = null)
    {
        $this->BeforeDeparture = $beforeDeparture;
        return $this;
    }
    /**
     * Get AfterDeparture value
     * @return bool|null
     */
    public function getAfterDeparture()
    {
        return $this->AfterDeparture;
    }
    /**
     * Set AfterDeparture value
     * @param bool $afterDeparture
     * @return \Sabre\AirTicket\Structs\EitherOr
     */
    public function setAfterDeparture($afterDeparture = null)
    {
        $this->AfterDeparture = $afterDeparture;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\EitherOr
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
