<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eTicket Structs
 * Meta informations extracted from the WSDL
 * - documentation: "eTicket" is used to send an email notification containing a text-based copy of the eTicket, cannot combine with .../Invoice, or .../Itinerary..
 * @subpackage Structs
 */
class ETicket extends AbstractStructBase
{
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Ind;
    /**
     * The PDF
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\PDF
     */
    public $PDF;
    /**
     * Constructor method for eTicket
     * @uses ETicket::setInd()
     * @uses ETicket::setPDF()
     * @param bool $ind
     * @param \Sabre\AirTicket\Structs\PDF $pDF
     */
    public function __construct($ind = null, \Sabre\AirTicket\Structs\PDF $pDF = null)
    {
        $this
            ->setInd($ind)
            ->setPDF($pDF);
    }
    /**
     * Get Ind value
     * @return bool
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\AirTicket\Structs\ETicket
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get PDF value
     * @return \Sabre\AirTicket\Structs\PDF|null
     */
    public function getPDF()
    {
        return $this->PDF;
    }
    /**
     * Set PDF value
     * @param \Sabre\AirTicket\Structs\PDF $pDF
     * @return \Sabre\AirTicket\Structs\ETicket
     */
    public function setPDF(\Sabre\AirTicket\Structs\PDF $pDF = null)
    {
        $this->PDF = $pDF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\ETicket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
