<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commission Structs
 * @subpackage Structs
 */
class Commission extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to specify the numeric amount of commission being claimed if applicable.
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: "Percent" is used to specify the precentage of commission being claimed if applicable.
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * Constructor method for Commission
     * @uses Commission::setAmount()
     * @uses Commission::setPercent()
     * @param float $amount
     * @param float $percent
     */
    public function __construct($amount = null, $percent = null)
    {
        $this
            ->setAmount($amount)
            ->setPercent($percent);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\AirTicket\Structs\Commission
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \Sabre\AirTicket\Structs\Commission
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Commission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
