<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingLines Structs
 * @subpackage Structs
 */
class AccountingLines extends AbstractStructBase
{
    /**
     * The Delete
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Delete[]
     */
    public $Delete;
    /**
     * The All
     * Meta informations extracted from the WSDL
     * - documentation: "All" is used to delete all accounting lines, cannot combine with attribute None.
     * - use: optional
     * @var bool
     */
    public $All;
    /**
     * The None
     * Meta informations extracted from the WSDL
     * - documentation: "None" is used to indicate not to delete any of the accounting lines, cannot combine with "All" attribute.
     * - use: optional
     * @var bool
     */
    public $None;
    /**
     * Constructor method for AccountingLines
     * @uses AccountingLines::setDelete()
     * @uses AccountingLines::setAll()
     * @uses AccountingLines::setNone()
     * @param \Sabre\AirTicket\Structs\Delete[] $delete
     * @param bool $all
     * @param bool $none
     */
    public function __construct(array $delete = array(), $all = null, $none = null)
    {
        $this
            ->setDelete($delete)
            ->setAll($all)
            ->setNone($none);
    }
    /**
     * Get Delete value
     * @return \Sabre\AirTicket\Structs\Delete[]|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Delete[] $delete
     * @return \Sabre\AirTicket\Structs\AccountingLines
     */
    public function setDelete(array $delete = array())
    {
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Add item to Delete value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Delete $item
     * @return \Sabre\AirTicket\Structs\AccountingLines
     */
    public function addToDelete(\Sabre\AirTicket\Structs\Delete $item)
    {
        $this->Delete[] = $item;
        return $this;
    }
    /**
     * Get All value
     * @return bool|null
     */
    public function getAll()
    {
        return $this->All;
    }
    /**
     * Set All value
     * @param bool $all
     * @return \Sabre\AirTicket\Structs\AccountingLines
     */
    public function setAll($all = null)
    {
        $this->All = $all;
        return $this;
    }
    /**
     * Get None value
     * @return bool|null
     */
    public function getNone()
    {
        return $this->None;
    }
    /**
     * Set None value
     * @param bool $none
     * @return \Sabre\AirTicket\Structs\AccountingLines
     */
    public function setNone($none = null)
    {
        $this->None = $none;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\AccountingLines
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
