<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecificPenalty Structs
 * Meta informations extracted from the WSDL
 * - documentation: "SpecificPenalty" is used to specify change or cancellation amounts for an itinerary.
 * @subpackage Structs
 */
class SpecificPenalty extends AbstractStructBase
{
    /**
     * The Changeable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Changeable
     */
    public $Changeable;
    /**
     * The EitherOr
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\EitherOr
     */
    public $EitherOr;
    /**
     * The Refundable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Refundable
     */
    public $Refundable;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - documentation: "AdditionalInfo" is used to receive additional tags with information on fare flexibility.
     * - use: optional
     * @var bool
     */
    public $AdditionalInfo;
    /**
     * Constructor method for SpecificPenalty
     * @uses SpecificPenalty::setChangeable()
     * @uses SpecificPenalty::setEitherOr()
     * @uses SpecificPenalty::setRefundable()
     * @uses SpecificPenalty::setAdditionalInfo()
     * @param \Sabre\AirTicket\Structs\Changeable $changeable
     * @param \Sabre\AirTicket\Structs\EitherOr $eitherOr
     * @param \Sabre\AirTicket\Structs\Refundable $refundable
     * @param bool $additionalInfo
     */
    public function __construct(\Sabre\AirTicket\Structs\Changeable $changeable = null, \Sabre\AirTicket\Structs\EitherOr $eitherOr = null, \Sabre\AirTicket\Structs\Refundable $refundable = null, $additionalInfo = null)
    {
        $this
            ->setChangeable($changeable)
            ->setEitherOr($eitherOr)
            ->setRefundable($refundable)
            ->setAdditionalInfo($additionalInfo);
    }
    /**
     * Get Changeable value
     * @return \Sabre\AirTicket\Structs\Changeable|null
     */
    public function getChangeable()
    {
        return $this->Changeable;
    }
    /**
     * Set Changeable value
     * @param \Sabre\AirTicket\Structs\Changeable $changeable
     * @return \Sabre\AirTicket\Structs\SpecificPenalty
     */
    public function setChangeable(\Sabre\AirTicket\Structs\Changeable $changeable = null)
    {
        $this->Changeable = $changeable;
        return $this;
    }
    /**
     * Get EitherOr value
     * @return \Sabre\AirTicket\Structs\EitherOr|null
     */
    public function getEitherOr()
    {
        return $this->EitherOr;
    }
    /**
     * Set EitherOr value
     * @param \Sabre\AirTicket\Structs\EitherOr $eitherOr
     * @return \Sabre\AirTicket\Structs\SpecificPenalty
     */
    public function setEitherOr(\Sabre\AirTicket\Structs\EitherOr $eitherOr = null)
    {
        $this->EitherOr = $eitherOr;
        return $this;
    }
    /**
     * Get Refundable value
     * @return \Sabre\AirTicket\Structs\Refundable|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param \Sabre\AirTicket\Structs\Refundable $refundable
     * @return \Sabre\AirTicket\Structs\SpecificPenalty
     */
    public function setRefundable(\Sabre\AirTicket\Structs\Refundable $refundable = null)
    {
        $this->Refundable = $refundable;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return bool|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param bool $additionalInfo
     * @return \Sabre\AirTicket\Structs\SpecificPenalty
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\SpecificPenalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
