<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reference Structs
 * Meta informations extracted from the WSDL
 * - type: ds:ReferenceType
 * @subpackage Structs
 */
class Reference extends AbstractStructBase
{
    /**
     * The href
     * Meta informations extracted from the WSDL
     * - ref: xlink:href
     * - use: required
     * @var string
     */
    public $href;
    /**
     * The Schema
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Schema
     * @var \Sabre\AirTicket\Structs\Schema[]
     */
    public $Schema;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \Sabre\AirTicket\Structs\Description[]
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - ref: tns:id
     * @var string
     */
    public $id;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - fixed: simple
     * - ref: xlink:type
     * @var string
     */
    public $type;
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - ref: xlink:role
     * @var string
     */
    public $role;
    /**
     * Constructor method for Reference
     * @uses Reference::setHref()
     * @uses Reference::setSchema()
     * @uses Reference::setDescription()
     * @uses Reference::setAny()
     * @uses Reference::setId()
     * @uses Reference::setType()
     * @uses Reference::setRole()
     * @param string $href
     * @param \Sabre\AirTicket\Structs\Schema[] $schema
     * @param \Sabre\AirTicket\Structs\Description[] $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $type
     * @param string $role
     */
    public function __construct($href = null, array $schema = array(), array $description = array(), \DOMDocument $any = null, $id = null, $type = null, $role = null)
    {
        $this
            ->setHref($href)
            ->setSchema($schema)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setType($type)
            ->setRole($role);
    }
    /**
     * Get href value
     * @return string
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param string $href
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function setHref($href = null)
    {
        $this->href = $href;
        return $this;
    }
    /**
     * Get Schema value
     * @return \Sabre\AirTicket\Structs\Schema[]|null
     */
    public function getSchema()
    {
        return $this->Schema;
    }
    /**
     * Set Schema value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Schema[] $schema
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function setSchema(array $schema = array())
    {
        $this->Schema = $schema;
        return $this;
    }
    /**
     * Add item to Schema value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Schema $item
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function addToSchema(\Sabre\AirTicket\Structs\Schema $item)
    {
        $this->Schema[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \Sabre\AirTicket\Structs\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Description[] $description
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Description $item
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function addToDescription(\Sabre\AirTicket\Structs\Description $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\AirTicket\Structs\Reference::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public function setRole($role = null)
    {
        $this->role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Reference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
