<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Itinerary Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Itinerary" is used to send an email notification containing a text-based copy of the itinerary. Itinerary cannot combine with .../eTicket, or .../Invoice.
 * @subpackage Structs
 */
class Itinerary extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ID;
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Ind;
    /**
     * The PDF
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\PDF
     */
    public $PDF;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Segment[]
     */
    public $Segment;
    /**
     * Constructor method for Itinerary
     * @uses Itinerary::setID()
     * @uses Itinerary::setInd()
     * @uses Itinerary::setPDF()
     * @uses Itinerary::setSegment()
     * @param string $iD
     * @param bool $ind
     * @param \Sabre\AirTicket\Structs\PDF $pDF
     * @param \Sabre\AirTicket\Structs\Segment[] $segment
     */
    public function __construct($iD = null, $ind = null, \Sabre\AirTicket\Structs\PDF $pDF = null, array $segment = array())
    {
        $this
            ->setID($iD)
            ->setInd($ind)
            ->setPDF($pDF)
            ->setSegment($segment);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Sabre\AirTicket\Structs\Itinerary
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Ind value
     * @return bool
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\AirTicket\Structs\Itinerary
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get PDF value
     * @return \Sabre\AirTicket\Structs\PDF|null
     */
    public function getPDF()
    {
        return $this->PDF;
    }
    /**
     * Set PDF value
     * @param \Sabre\AirTicket\Structs\PDF $pDF
     * @return \Sabre\AirTicket\Structs\Itinerary
     */
    public function setPDF(\Sabre\AirTicket\Structs\PDF $pDF = null)
    {
        $this->PDF = $pDF;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\AirTicket\Structs\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Segment[] $segment
     * @return \Sabre\AirTicket\Structs\Itinerary
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Segment $item
     * @return \Sabre\AirTicket\Structs\Itinerary
     */
    public function addToSegment(\Sabre\AirTicket\Structs\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Itinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
