<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fare Structs
 * @subpackage Structs
 */
class Fare extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to specify the amount to be applied to the second FOP. | "Amount" is used to specify the fare amount to be applied to the second FOP. | "Amount" is used to specify the remaining fare amount. | "Amount" is used to
     * specify the amount to be applied to the second CC. | "Amount" is used to specify the fare amount to be applied to the second FOP. | "Amount" is used to specify the fare amount to be applied to the second FOP.
     * - use: required
     * @var string
     */
    public $Amount;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to specify a fare type. Acceptable values are "NL" for normal fare, "EX" for special fare, and 'IT" for inclusive tour.
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Fare
     * @uses Fare::setAmount()
     * @uses Fare::setType()
     * @param string $amount
     * @param string $type
     */
    public function __construct($amount = null, $type = null)
    {
        $this
            ->setAmount($amount)
            ->setType($type);
    }
    /**
     * Get Amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\AirTicket\Structs\Fare
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\AirTicket\Structs\Fare
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Fare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
